/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.polaris.core.admin.model.AwsStorageConfigInfo;
import org.apache.polaris.core.admin.model.AzureStorageConfigInfo;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.ExternalCatalog;
import org.apache.polaris.core.admin.model.FileStorageConfigInfo;
import org.apache.polaris.core.admin.model.GcpStorageConfigInfo;
import org.apache.polaris.core.admin.model.PolarisCatalog;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.core.config.BehaviorChangeConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.entity.LocationBasedEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.identity.dpo.ServiceIdentityInfoDpo;
import org.apache.polaris.core.identity.provider.ServiceIdentityProvider;
import org.apache.polaris.core.secrets.SecretReference;
import org.apache.polaris.core.storage.FileStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.aws.AwsStorageConfigurationInfo;
import org.apache.polaris.core.storage.aws.ImmutableAwsStorageConfigurationInfo;
import org.apache.polaris.core.storage.azure.AzureStorageConfigurationInfo;
import org.apache.polaris.core.storage.gcp.GcpStorageConfigurationInfo;

public class CatalogEntity
extends PolarisEntity
implements LocationBasedEntity {
    public static final String CATALOG_TYPE_PROPERTY = "catalogType";
    public static final String DEFAULT_BASE_LOCATION_KEY = "default-base-location";
    public static final String REPLACE_NEW_LOCATION_PREFIX_WITH_CATALOG_DEFAULT_KEY = "replace-new-location-prefix-with-catalog-default";

    public CatalogEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
        Preconditions.checkState((this.getType() == PolarisEntityType.CATALOG ? 1 : 0) != 0, (String)"Invalid entity type: %s", (Object)((Object)this.getType()));
        Preconditions.checkState((this.getSubType() == PolarisEntitySubType.NULL_SUBTYPE ? 1 : 0) != 0, (String)"Invalid entity sub type: %s", (Object)((Object)this.getSubType()));
    }

    @Nullable
    public static CatalogEntity of(@Nullable PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new CatalogEntity(sourceEntity);
        }
        return null;
    }

    public static CatalogEntity fromCatalog(RealmConfig realmConfig, Catalog catalog) {
        Builder builder = ((Builder)((Builder)new Builder().setName(catalog.getName())).setProperties(catalog.getProperties().toMap())).setCatalogType(catalog.getType().name());
        HashMap<String, String> internalProperties = new HashMap<String, String>();
        internalProperties.put(CATALOG_TYPE_PROPERTY, catalog.getType().name());
        builder.setInternalProperties(internalProperties);
        builder.setStorageConfigurationInfo(realmConfig, catalog.getStorageConfigInfo(), CatalogEntity.getBaseLocation(catalog));
        return builder.build();
    }

    public Catalog asCatalog() {
        return this.asCatalog(null);
    }

    public Catalog asCatalog(ServiceIdentityProvider serviceIdentityProvider) {
        Map<String, String> internalProperties = this.getInternalPropertiesAsMap();
        Catalog.TypeEnum catalogType = Optional.ofNullable(internalProperties.get(CATALOG_TYPE_PROPERTY)).map(Catalog.TypeEnum::valueOf).orElseGet(() -> this.getName().equalsIgnoreCase("ROOT") ? Catalog.TypeEnum.INTERNAL : null);
        Map<String, String> propertiesMap = this.getPropertiesAsMap();
        CatalogProperties catalogProps = CatalogProperties.builder((String)propertiesMap.get(DEFAULT_BASE_LOCATION_KEY)).putAll(propertiesMap).build();
        Preconditions.checkState((catalogType != Catalog.TypeEnum.EXTERNAL || serviceIdentityProvider != null ? 1 : 0) != 0, (String)"%s catalog needs ServiceIdentityProvider to resolve service identities", (Object)Catalog.TypeEnum.EXTERNAL);
        return catalogType == Catalog.TypeEnum.EXTERNAL ? ExternalCatalog.builder().setType(Catalog.TypeEnum.EXTERNAL).setName(this.getName()).setProperties(catalogProps).setCreateTimestamp(Long.valueOf(this.getCreateTimestamp())).setLastUpdateTimestamp(Long.valueOf(this.getLastUpdateTimestamp())).setEntityVersion(Integer.valueOf(this.getEntityVersion())).setStorageConfigInfo(this.getStorageInfo(internalProperties)).setConnectionConfigInfo(this.getConnectionInfo(internalProperties, serviceIdentityProvider)).build() : PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(this.getName()).setProperties(catalogProps).setCreateTimestamp(Long.valueOf(this.getCreateTimestamp())).setLastUpdateTimestamp(Long.valueOf(this.getLastUpdateTimestamp())).setEntityVersion(Integer.valueOf(this.getEntityVersion())).setStorageConfigInfo(this.getStorageInfo(internalProperties)).build();
    }

    private StorageConfigInfo getStorageInfo(Map<String, String> internalProperties) {
        if (internalProperties.containsKey(PolarisEntityConstants.getStorageConfigInfoPropertyName())) {
            PolarisStorageConfigurationInfo configInfo = this.getStorageConfigurationInfo();
            if (configInfo instanceof AwsStorageConfigurationInfo) {
                AwsStorageConfigurationInfo awsConfig = (AwsStorageConfigurationInfo)configInfo;
                return AwsStorageConfigInfo.builder().setRoleArn(awsConfig.getRoleARN()).setExternalId(awsConfig.getExternalId()).setUserArn(awsConfig.getUserARN()).setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(awsConfig.getAllowedLocations()).setRegion(awsConfig.getRegion()).setEndpoint(awsConfig.getEndpoint()).setStsEndpoint(awsConfig.getStsEndpoint()).setPathStyleAccess(awsConfig.getPathStyleAccess()).setStsUnavailable(awsConfig.getStsUnavailable()).setEndpointInternal(awsConfig.getEndpointInternal()).build();
            }
            if (configInfo instanceof AzureStorageConfigurationInfo) {
                AzureStorageConfigurationInfo azureConfig = (AzureStorageConfigurationInfo)configInfo;
                return AzureStorageConfigInfo.builder().setTenantId(azureConfig.getTenantId()).setMultiTenantAppName(azureConfig.getMultiTenantAppName()).setConsentUrl(azureConfig.getConsentUrl()).setStorageType(StorageConfigInfo.StorageTypeEnum.AZURE).setAllowedLocations(azureConfig.getAllowedLocations()).build();
            }
            if (configInfo instanceof GcpStorageConfigurationInfo) {
                GcpStorageConfigurationInfo gcpConfigModel = (GcpStorageConfigurationInfo)configInfo;
                return GcpStorageConfigInfo.builder().setGcsServiceAccount(gcpConfigModel.getGcpServiceAccount()).setStorageType(StorageConfigInfo.StorageTypeEnum.GCS).setAllowedLocations(gcpConfigModel.getAllowedLocations()).build();
            }
            if (configInfo instanceof FileStorageConfigurationInfo) {
                FileStorageConfigurationInfo fileConfigModel = (FileStorageConfigurationInfo)configInfo;
                return new FileStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.FILE, fileConfigModel.getAllowedLocations());
            }
            return null;
        }
        return null;
    }

    private ConnectionConfigInfo getConnectionInfo(Map<String, String> internalProperties, ServiceIdentityProvider serviceIdentityProvider) {
        if (internalProperties.containsKey(PolarisEntityConstants.getConnectionConfigInfoPropertyName())) {
            ConnectionConfigInfoDpo configInfo = this.getConnectionConfigInfoDpo();
            return configInfo.asConnectionConfigInfoModel(serviceIdentityProvider);
        }
        return null;
    }

    @Override
    public String getBaseLocation() {
        return this.getPropertiesAsMap().get(DEFAULT_BASE_LOCATION_KEY);
    }

    public String getReplaceNewLocationPrefixWithCatalogDefault() {
        return this.getPropertiesAsMap().get(REPLACE_NEW_LOCATION_PREFIX_WITH_CATALOG_DEFAULT_KEY);
    }

    @Nullable
    public PolarisStorageConfigurationInfo getStorageConfigurationInfo() {
        String configStr = this.getInternalPropertiesAsMap().get(PolarisEntityConstants.getStorageConfigInfoPropertyName());
        if (configStr != null) {
            return PolarisStorageConfigurationInfo.deserialize(configStr);
        }
        return null;
    }

    public Catalog.TypeEnum getCatalogType() {
        return Optional.ofNullable(this.getInternalPropertiesAsMap().get(CATALOG_TYPE_PROPERTY)).map(Catalog.TypeEnum::valueOf).orElse(null);
    }

    public boolean isExternal() {
        return this.getCatalogType() == Catalog.TypeEnum.EXTERNAL;
    }

    public boolean isPassthroughFacade() {
        return this.getInternalPropertiesAsMap().containsKey(PolarisEntityConstants.getConnectionConfigInfoPropertyName());
    }

    public boolean isStaticFacade() {
        return this.isExternal() && !this.isPassthroughFacade();
    }

    public ConnectionConfigInfoDpo getConnectionConfigInfoDpo() {
        String configStr = this.getInternalPropertiesAsMap().get(PolarisEntityConstants.getConnectionConfigInfoPropertyName());
        if (configStr != null) {
            return ConnectionConfigInfoDpo.deserialize(configStr);
        }
        return null;
    }

    @Nonnull
    protected static String getBaseLocation(Catalog catalog) {
        return catalog.getProperties().getDefaultBaseLocation();
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<CatalogEntity, Builder> {
        public Builder() {
            this.setType(PolarisEntityType.CATALOG);
            this.setCatalogId(PolarisEntityConstants.getNullId());
            this.setParentId(PolarisEntityConstants.getRootEntityId());
        }

        public Builder(CatalogEntity original) {
            super(original);
        }

        public Builder setCatalogType(String type) {
            this.internalProperties.put(CatalogEntity.CATALOG_TYPE_PROPERTY, type);
            return this;
        }

        public Builder setDefaultBaseLocation(String defaultBaseLocation) {
            this.properties.put(CatalogEntity.DEFAULT_BASE_LOCATION_KEY, defaultBaseLocation);
            return this;
        }

        public Builder setReplaceNewLocationPrefixWithCatalogDefault(String value) {
            this.properties.put(CatalogEntity.REPLACE_NEW_LOCATION_PREFIX_WITH_CATALOG_DEFAULT_KEY, value);
            return this;
        }

        public Builder setStorageConfigurationInfo(RealmConfig realmConfig, StorageConfigInfo storageConfigModel, String defaultBaseLocation) {
            if (storageConfigModel != null) {
                PolarisStorageConfigurationInfo config;
                HashSet<String> allowedLocations = new HashSet<String>(storageConfigModel.getAllowedLocations());
                if (defaultBaseLocation == null) {
                    throw new BadRequestException("Must specify default base location", new Object[0]);
                }
                allowedLocations.add(defaultBaseLocation);
                this.validateMaxAllowedLocations(realmConfig, allowedLocations);
                switch (storageConfigModel.getStorageType()) {
                    case S3: {
                        AwsStorageConfigInfo awsConfigModel = (AwsStorageConfigInfo)storageConfigModel;
                        ImmutableAwsStorageConfigurationInfo awsConfig = AwsStorageConfigurationInfo.builder().allowedLocations(allowedLocations).roleARN(awsConfigModel.getRoleArn()).externalId(awsConfigModel.getExternalId()).region(awsConfigModel.getRegion()).endpoint(awsConfigModel.getEndpoint()).stsEndpoint(awsConfigModel.getStsEndpoint()).pathStyleAccess(awsConfigModel.getPathStyleAccess()).stsUnavailable(awsConfigModel.getStsUnavailable()).endpointInternal(awsConfigModel.getEndpointInternal()).build();
                        config = awsConfig;
                        break;
                    }
                    case AZURE: {
                        AzureStorageConfigInfo azureConfigModel = (AzureStorageConfigInfo)storageConfigModel;
                        config = AzureStorageConfigurationInfo.builder().allowedLocations(allowedLocations).tenantId(azureConfigModel.getTenantId()).multiTenantAppName(azureConfigModel.getMultiTenantAppName()).consentUrl(azureConfigModel.getConsentUrl()).build();
                        break;
                    }
                    case GCS: {
                        config = GcpStorageConfigurationInfo.builder().allowedLocations(allowedLocations).gcpServiceAccount(((GcpStorageConfigInfo)storageConfigModel).getGcsServiceAccount()).build();
                        break;
                    }
                    case FILE: {
                        config = FileStorageConfigurationInfo.builder().allowedLocations(allowedLocations).build();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported storage type: " + String.valueOf(storageConfigModel.getStorageType()));
                    }
                }
                this.internalProperties.put(PolarisEntityConstants.getStorageConfigInfoPropertyName(), config.serialize());
            }
            return this;
        }

        private void validateMaxAllowedLocations(RealmConfig realmConfig, Collection<String> allowedLocations) {
            int maxAllowedLocations = realmConfig.getConfig(BehaviorChangeConfiguration.STORAGE_CONFIGURATION_MAX_LOCATIONS);
            if (maxAllowedLocations != -1 && allowedLocations.size() > maxAllowedLocations) {
                throw new IllegalArgumentException(String.format("Number of configured locations (%s) exceeds the limit of %s", allowedLocations.size(), maxAllowedLocations));
            }
        }

        public Builder setConnectionConfigInfoDpoWithSecrets(ConnectionConfigInfo connectionConfigurationModel, Map<String, SecretReference> secretReferences, ServiceIdentityInfoDpo serviceIdentityInfoDpo) {
            if (connectionConfigurationModel != null) {
                ConnectionConfigInfoDpo config = ConnectionConfigInfoDpo.fromConnectionConfigInfoModelWithSecrets(connectionConfigurationModel, secretReferences).withServiceIdentity(serviceIdentityInfoDpo);
                this.internalProperties.put(PolarisEntityConstants.getConnectionConfigInfoPropertyName(), config.serialize());
            }
            return this;
        }

        public Builder setConnectionConfigInfoDpo(@Nonnull ConnectionConfigInfoDpo connectionConfigInfoDpo) {
            this.internalProperties.put(PolarisEntityConstants.getConnectionConfigInfoPropertyName(), connectionConfigInfoDpo.serialize());
            return this;
        }

        @Override
        public CatalogEntity build() {
            return new CatalogEntity(this.buildBase());
        }
    }
}

