/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.math.BigInteger;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.tsfile.read.filter.basic.Filter;

public class TimePartitionUtils {
    private static long timePartitionOrigin = CommonDescriptor.getInstance().getConfig().getTimePartitionOrigin();
    private static long timePartitionInterval = CommonDescriptor.getInstance().getConfig().getTimePartitionInterval();
    private static final BigInteger bigTimePartitionOrigin = BigInteger.valueOf(timePartitionOrigin);
    private static final BigInteger bigTimePartitionInterval = BigInteger.valueOf(timePartitionInterval);
    private static final boolean originMayCauseOverflow = timePartitionOrigin != 0L;
    private static final long timePartitionLowerBoundWithoutOverflow;
    private static final long timePartitionUpperBoundWithoutOverflow;

    public static TTimePartitionSlot getTimePartitionSlot(long time) {
        TTimePartitionSlot timePartitionSlot = new TTimePartitionSlot();
        timePartitionSlot.setStartTime(TimePartitionUtils.getTimePartitionLowerBound(time));
        return timePartitionSlot;
    }

    public static long getTimePartitionInterval() {
        return timePartitionInterval;
    }

    public static long getTimePartitionLowerBound(long time) {
        if (time < timePartitionLowerBoundWithoutOverflow) {
            return Long.MIN_VALUE;
        }
        if (originMayCauseOverflow) {
            return BigInteger.valueOf(TimePartitionUtils.getTimePartitionIdWithoutOverflow(time)).multiply(bigTimePartitionInterval).add(bigTimePartitionOrigin).longValue();
        }
        return TimePartitionUtils.getTimePartitionId(time) * timePartitionInterval + timePartitionOrigin;
    }

    public static long getTimePartitionUpperBound(long time) {
        if (time >= timePartitionUpperBoundWithoutOverflow) {
            return Long.MAX_VALUE;
        }
        long lowerBound = TimePartitionUtils.getTimePartitionLowerBound(time);
        return lowerBound == Long.MIN_VALUE ? timePartitionLowerBoundWithoutOverflow : lowerBound + timePartitionInterval;
    }

    public static long getTimePartitionId(long time) {
        return (time -= timePartitionOrigin) > 0L || time % timePartitionInterval == 0L ? time / timePartitionInterval : time / timePartitionInterval - 1L;
    }

    public static long getTimePartitionIdWithoutOverflow(long time) {
        BigInteger bigTime = BigInteger.valueOf(time).subtract(bigTimePartitionOrigin);
        BigInteger partitionId = bigTime.compareTo(BigInteger.ZERO) > 0 || bigTime.remainder(bigTimePartitionInterval).equals(BigInteger.ZERO) ? bigTime.divide(bigTimePartitionInterval) : bigTime.divide(bigTimePartitionInterval).subtract(BigInteger.ONE);
        return partitionId.longValue();
    }

    public static boolean satisfyPartitionId(long startTime, long endTime, long partitionId) {
        long startPartition = originMayCauseOverflow ? TimePartitionUtils.getTimePartitionIdWithoutOverflow(startTime) : TimePartitionUtils.getTimePartitionId(startTime);
        long endPartition = originMayCauseOverflow ? TimePartitionUtils.getTimePartitionIdWithoutOverflow(endTime) : TimePartitionUtils.getTimePartitionId(endTime);
        return startPartition <= partitionId && endPartition >= partitionId;
    }

    public static boolean satisfyPartitionStartTime(Filter timeFilter, long partitionStartTime) {
        if (timeFilter == null) {
            return true;
        }
        long partitionEndTime = partitionStartTime >= timePartitionLowerBoundWithoutOverflow ? Long.MAX_VALUE : partitionStartTime + timePartitionInterval - 1L;
        return timeFilter.satisfyStartEndTime(partitionStartTime, partitionEndTime);
    }

    public static boolean satisfyTimePartition(Filter timeFilter, long partitionId) {
        long partitionStartTime = originMayCauseOverflow ? BigInteger.valueOf(partitionId).multiply(bigTimePartitionInterval).add(bigTimePartitionOrigin).longValue() : partitionId * timePartitionInterval + timePartitionOrigin;
        return TimePartitionUtils.satisfyPartitionStartTime(timeFilter, partitionStartTime);
    }

    public static void setTimePartitionInterval(long timePartitionInterval) {
        TimePartitionUtils.timePartitionInterval = timePartitionInterval;
    }

    public static long getEstimateTimePartitionSize(long startTime, long endTime) {
        if (endTime > 0L && startTime < 0L) {
            return BigInteger.valueOf(endTime).subtract(BigInteger.valueOf(startTime)).divide(bigTimePartitionInterval).longValue() + 1L;
        }
        return (endTime - startTime) / timePartitionInterval + 1L;
    }

    static {
        long minPartition = TimePartitionUtils.getTimePartitionIdWithoutOverflow(Long.MIN_VALUE);
        long maxPartition = TimePartitionUtils.getTimePartitionIdWithoutOverflow(Long.MAX_VALUE);
        BigInteger minPartitionStartTime = BigInteger.valueOf(minPartition).multiply(bigTimePartitionInterval).add(bigTimePartitionOrigin);
        BigInteger maxPartitionEndTime = BigInteger.valueOf(maxPartition).multiply(bigTimePartitionInterval).add(bigTimePartitionInterval).add(bigTimePartitionOrigin);
        timePartitionLowerBoundWithoutOverflow = minPartitionStartTime.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 ? minPartitionStartTime.add(bigTimePartitionInterval).longValue() : minPartitionStartTime.longValue();
        timePartitionUpperBoundWithoutOverflow = maxPartitionEndTime.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 ? maxPartitionEndTime.subtract(bigTimePartitionInterval).longValue() : maxPartitionEndTime.longValue();
    }
}

