/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Master;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.Type;

public class Cache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Cache.class);
    private CacheMap data;
    private int maxncache = -1;
    private int maxcache = -1;
    private int dclass;
    private static final int defaultMaxEntries = 50000;

    private static int limitExpire(long ttl, long maxttl) {
        long expire;
        if (maxttl >= 0L && maxttl < ttl) {
            ttl = maxttl;
        }
        if ((expire = System.currentTimeMillis() / 1000L + ttl) < 0L || expire > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)expire;
    }

    public Cache(int dclass) {
        this.dclass = dclass;
        this.data = new CacheMap(50000);
    }

    public Cache() {
        this(1);
    }

    public Cache(String file) throws IOException {
        this.data = new CacheMap(50000);
        try (Master m = new Master(file);){
            Record record;
            while ((record = m.nextRecord()) != null) {
                this.addRecord(record, 0);
            }
        }
    }

    private synchronized Object exactName(Name name) {
        return this.data.get(name);
    }

    private synchronized void removeName(Name name) {
        this.data.remove(name);
    }

    private synchronized Element[] allElements(Object types) {
        if (types instanceof List) {
            List typelist = (List)types;
            int size = typelist.size();
            return typelist.toArray(new Element[size]);
        }
        Element set = (Element)types;
        return new Element[]{set};
    }

    private synchronized Element oneElement(Name name, Object types, int type, int minCred) {
        Element found = null;
        if (type == 255) {
            throw new IllegalArgumentException("oneElement(ANY)");
        }
        if (types instanceof List) {
            List list = (List)types;
            for (Element set : list) {
                if (set.getType() != type) continue;
                found = set;
                break;
            }
        } else {
            Element set = (Element)types;
            if (set.getType() == type) {
                found = set;
            }
        }
        if (found == null) {
            return null;
        }
        if (found.expired()) {
            this.removeElement(name, type);
            return null;
        }
        if (found.compareCredibility(minCred) < 0) {
            return null;
        }
        return found;
    }

    private synchronized Element findElement(Name name, int type, int minCred) {
        Object types = this.exactName(name);
        if (types == null) {
            return null;
        }
        return this.oneElement(name, types, type, minCred);
    }

    private synchronized void addElement(Name name, Element element) {
        Object types = this.data.get(name);
        if (types == null) {
            this.data.put(name, element);
            return;
        }
        int type = element.getType();
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                Element elt = (Element)list.get(i);
                if (elt.getType() != type) continue;
                list.set(i, element);
                return;
            }
            list.add(element);
        } else {
            Element elt = (Element)types;
            if (elt.getType() == type) {
                this.data.put(name, element);
            } else {
                LinkedList<Element> list = new LinkedList<Element>();
                list.add(elt);
                list.add(element);
                this.data.put(name, list);
            }
        }
    }

    private synchronized void removeElement(Name name, int type) {
        Object types = this.data.get(name);
        if (types == null) {
            return;
        }
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                Element elt = (Element)list.get(i);
                if (elt.getType() != type) continue;
                list.remove(i);
                if (list.size() == 0) {
                    this.data.remove(name);
                }
                return;
            }
        } else {
            Element elt = (Element)types;
            if (elt.getType() != type) {
                return;
            }
            this.data.remove(name);
        }
    }

    public synchronized void clearCache() {
        this.data.clear();
    }

    @Deprecated
    public synchronized void addRecord(Record r, int cred, Object o) {
        this.addRecord(r, cred);
    }

    public synchronized void addRecord(Record r, int cred) {
        Name name = r.getName();
        int type = r.getRRsetType();
        if (!Type.isRR(type)) {
            return;
        }
        Element element = this.findElement(name, type, cred);
        if (element == null) {
            CacheRRset crrset = new CacheRRset(r, cred, (long)this.maxcache);
            this.addRRset(crrset, cred);
        } else if (element.compareCredibility(cred) == 0 && element instanceof CacheRRset) {
            CacheRRset crrset = (CacheRRset)element;
            crrset.addRR(r);
        }
    }

    public synchronized <T extends Record> void addRRset(RRset rrset, int cred) {
        long ttl = rrset.getTTL();
        Name name = rrset.getName();
        int type = rrset.getType();
        Element element = this.findElement(name, type, 0);
        if (ttl == 0L) {
            if (element != null && element.compareCredibility(cred) <= 0) {
                this.removeElement(name, type);
            }
        } else {
            if (element != null && element.compareCredibility(cred) <= 0) {
                element = null;
            }
            if (element == null) {
                CacheRRset crrset = rrset instanceof CacheRRset ? (CacheRRset)rrset : new CacheRRset(rrset, cred, (long)this.maxcache);
                this.addElement(name, crrset);
            }
        }
    }

    public synchronized void addNegative(Name name, int type, SOARecord soa, int cred) {
        long ttl = 0L;
        if (soa != null) {
            ttl = Math.min(soa.getMinimum(), soa.getTTL());
        }
        Element element = this.findElement(name, type, 0);
        if (ttl == 0L) {
            if (element != null && element.compareCredibility(cred) <= 0) {
                this.removeElement(name, type);
            }
        } else {
            if (element != null && element.compareCredibility(cred) <= 0) {
                element = null;
            }
            if (element == null) {
                this.addElement(name, new NegativeElement(name, type, soa, cred, this.maxncache));
            }
        }
    }

    protected synchronized SetResponse lookup(Name name, int type, int minCred) {
        int labels;
        for (int tlabels = labels = name.labels(); tlabels >= 1; --tlabels) {
            Element element;
            SetResponse sr;
            boolean isExact;
            boolean isRoot = tlabels == 1;
            boolean bl = isExact = tlabels == labels;
            Name tname = isRoot ? Name.root : (isExact ? name : new Name(name, labels - tlabels));
            Object types = this.data.get(tname);
            if (types == null) continue;
            if (isExact && type == 255) {
                sr = new SetResponse(6);
                Element[] elements = this.allElements(types);
                int added = 0;
                for (Element value : elements) {
                    element = value;
                    if (element.expired()) {
                        this.removeElement(tname, element.getType());
                        continue;
                    }
                    if (!(element instanceof CacheRRset) || element.compareCredibility(minCred) < 0) continue;
                    sr.addRRset((CacheRRset)element);
                    ++added;
                }
                if (added > 0) {
                    return sr;
                }
            } else if (isExact) {
                element = this.oneElement(tname, types, type, minCred);
                if (element instanceof CacheRRset) {
                    sr = new SetResponse(6);
                    sr.addRRset((CacheRRset)element);
                    return sr;
                }
                if (element != null) {
                    sr = new SetResponse(2);
                    return sr;
                }
                element = this.oneElement(tname, types, 5, minCred);
                if (element instanceof CacheRRset) {
                    return new SetResponse(4, (CacheRRset)element);
                }
            } else {
                element = this.oneElement(tname, types, 39, minCred);
                if (element instanceof CacheRRset) {
                    return new SetResponse(5, (CacheRRset)element);
                }
            }
            if ((element = this.oneElement(tname, types, 2, minCred)) instanceof CacheRRset) {
                return new SetResponse(3, (CacheRRset)element);
            }
            if (!isExact || (element = this.oneElement(tname, types, 0, minCred)) == null) continue;
            return SetResponse.ofType(1);
        }
        return SetResponse.ofType(0);
    }

    public SetResponse lookupRecords(Name name, int type, int minCred) {
        return this.lookup(name, type, minCred);
    }

    private List<RRset> findRecords(Name name, int type, int minCred) {
        SetResponse cr = this.lookupRecords(name, type, minCred);
        if (cr.isSuccessful()) {
            return cr.answers();
        }
        return null;
    }

    public List<RRset> findRecords(Name name, int type) {
        return this.findRecords(name, type, 3);
    }

    public List<RRset> findAnyRecords(Name name, int type) {
        return this.findRecords(name, type, 2);
    }

    private int getCred(int section, boolean isAuth) {
        if (section == 1) {
            if (isAuth) {
                return 4;
            }
            return 3;
        }
        if (section == 2) {
            if (isAuth) {
                return 4;
            }
            return 3;
        }
        if (section == 3) {
            return 1;
        }
        throw new IllegalArgumentException("getCred: invalid section");
    }

    private static void markAdditional(RRset rrset, Set<Name> names) {
        Record first = rrset.first();
        if (first.getAdditionalName() == null) {
            return;
        }
        for (Record r : rrset.rrs()) {
            Name name = r.getAdditionalName();
            if (name == null) continue;
            names.add(name);
        }
    }

    public SetResponse addMessage(Message in) {
        int cred;
        boolean isAuth = in.getHeader().getFlag(5);
        Record question = in.getQuestion();
        int rcode = in.getHeader().getRcode();
        boolean completed = false;
        SetResponse response = null;
        if (rcode != 0 && rcode != 3 || question == null) {
            return null;
        }
        Name qname = question.getName();
        int qtype = question.getType();
        int qclass = question.getDClass();
        Name curname = qname;
        HashSet<Name> additionalNames = new HashSet<Name>();
        List<RRset> answers = in.getSectionRRsets(1);
        for (RRset answer : answers) {
            if (answer.getDClass() != qclass) continue;
            int type = answer.getType();
            Name name = answer.getName();
            cred = this.getCred(1, isAuth);
            if ((type == qtype || qtype == 255) && name.equals(curname)) {
                this.addRRset(answer, cred);
                completed = true;
                if (curname == qname) {
                    if (response == null) {
                        response = new SetResponse(6);
                    }
                    response.addRRset(answer);
                }
                Cache.markAdditional(answer, additionalNames);
                continue;
            }
            if (type == 5 && name.equals(curname)) {
                this.addRRset(answer, cred);
                if (curname == qname) {
                    response = new SetResponse(4, answer);
                }
                CNAMERecord cname = (CNAMERecord)answer.first();
                curname = cname.getTarget();
                continue;
            }
            if (type != 39 || !curname.subdomain(name)) continue;
            this.addRRset(answer, cred);
            if (curname == qname) {
                response = new SetResponse(5, answer);
            }
            DNAMERecord dname = (DNAMERecord)answer.first();
            try {
                curname = curname.fromDNAME(dname);
            }
            catch (NameTooLongException e) {
                break;
            }
        }
        List<RRset> auth = in.getSectionRRsets(2);
        RRset soa = null;
        RRset ns = null;
        for (RRset rset : auth) {
            if (rset.getType() == 6 && curname.subdomain(rset.getName())) {
                soa = rset;
                continue;
            }
            if (rset.getType() != 2 || !curname.subdomain(rset.getName())) continue;
            ns = rset;
        }
        if (!completed) {
            int cachetype;
            int n = cachetype = rcode == 3 ? 0 : qtype;
            if (rcode == 3 || soa != null || ns == null) {
                cred = this.getCred(2, isAuth);
                SOARecord soarec = null;
                if (soa != null) {
                    soarec = (SOARecord)soa.first();
                }
                this.addNegative(curname, cachetype, soarec, cred);
                if (response == null) {
                    int responseType = rcode == 3 ? 1 : 2;
                    response = SetResponse.ofType(responseType);
                }
            } else {
                cred = this.getCred(2, isAuth);
                this.addRRset(ns, cred);
                Cache.markAdditional(ns, additionalNames);
                if (response == null) {
                    response = new SetResponse(3, ns);
                }
            }
        } else if (rcode == 0 && ns != null) {
            cred = this.getCred(2, isAuth);
            this.addRRset(ns, cred);
            Cache.markAdditional(ns, additionalNames);
        }
        List<RRset> addl = in.getSectionRRsets(3);
        for (RRset rRset : addl) {
            Name name;
            int type = rRset.getType();
            if (type != 1 && type != 28 && type != 38 || !additionalNames.contains(name = rRset.getName())) continue;
            cred = this.getCred(3, isAuth);
            this.addRRset(rRset, cred);
        }
        log.debug("Caching {} for {}/{}", new Object[]{response, in.getQuestion().getName(), Type.string(in.getQuestion().getType())});
        return response;
    }

    public void flushSet(Name name, int type) {
        this.removeElement(name, type);
    }

    public void flushName(Name name) {
        this.removeName(name);
    }

    public void setMaxNCache(int seconds) {
        this.maxncache = seconds;
    }

    public int getMaxNCache() {
        return this.maxncache;
    }

    public void setMaxCache(int seconds) {
        this.maxcache = seconds;
    }

    public int getMaxCache() {
        return this.maxcache;
    }

    public int getSize() {
        return this.data.size();
    }

    public int getMaxEntries() {
        return this.data.getMaxSize();
    }

    public void setMaxEntries(int entries) {
        this.data.setMaxSize(entries);
    }

    public int getDClass() {
        return this.dclass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Cache cache = this;
        synchronized (cache) {
            for (Object o : this.data.values()) {
                Element[] elements;
                for (Element element : elements = this.allElements(o)) {
                    sb.append(element);
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }

    private static class CacheMap
    extends LinkedHashMap<Name, Object> {
        private int maxsize;

        CacheMap(int maxsize) {
            super(16, 0.75f, true);
            this.maxsize = maxsize;
        }

        int getMaxSize() {
            return this.maxsize;
        }

        void setMaxSize(int maxsize) {
            this.maxsize = maxsize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.maxsize >= 0 && this.size() > this.maxsize;
        }
    }

    private static class NegativeElement
    implements Element {
        int type;
        Name name;
        int credibility;
        int expire;

        public NegativeElement(Name name, int type, SOARecord soa, int cred, long maxttl) {
            this.name = name;
            this.type = type;
            long cttl = 0L;
            if (soa != null) {
                cttl = Math.min(soa.getMinimum(), soa.getTTL());
            }
            this.credibility = cred;
            this.expire = Cache.limitExpire(cttl, maxttl);
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public final boolean expired() {
            int now = (int)(System.currentTimeMillis() / 1000L);
            return now >= this.expire;
        }

        @Override
        public final int compareCredibility(int cred) {
            return this.credibility - cred;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.type == 0) {
                sb.append("NXDOMAIN ").append(this.name);
            } else {
                sb.append("NXRRSET ").append(this.name).append(" ").append(Type.string(this.type));
            }
            sb.append(" cl = ");
            sb.append(this.credibility);
            return sb.toString();
        }
    }

    private static class CacheRRset
    extends RRset
    implements Element {
        private static final long serialVersionUID = 5971755205903597024L;
        int credibility;
        int expire;

        public CacheRRset(Record rec, int cred, long maxttl) {
            this.credibility = cred;
            this.expire = Cache.limitExpire(rec.getTTL(), maxttl);
            this.addRR(rec);
        }

        public CacheRRset(RRset rrset, int cred, long maxttl) {
            super(rrset);
            this.credibility = cred;
            this.expire = Cache.limitExpire(rrset.getTTL(), maxttl);
        }

        @Override
        public final boolean expired() {
            int now = (int)(System.currentTimeMillis() / 1000L);
            return now >= this.expire;
        }

        @Override
        public final int compareCredibility(int cred) {
            return this.credibility - cred;
        }

        @Override
        public String toString() {
            return super.toString() + " cl = " + this.credibility;
        }
    }

    private static interface Element {
        public boolean expired();

        public int compareCredibility(int var1);

        public int getType();
    }
}

