/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.selector.filter;

import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.activemq.artemis.selector.filter.BooleanExpression;
import org.apache.activemq.artemis.selector.filter.ConstantExpression;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.selector.filter.JAXPXPathEvaluator;

public final class XPathExpression
implements BooleanExpression {
    private final String xpath;
    private final XPathEvaluator evaluator;
    private static DocumentBuilder builder;
    public static XPathEvaluatorFactory XPATH_EVALUATOR_FACTORY;
    public static final String DOCUMENT_BUILDER_FACTORY_FEATURE_PREFIX = "org.apache.activemq.documentBuilderFactory.feature:";

    XPathExpression(String xpath) {
        if (XPATH_EVALUATOR_FACTORY == null) {
            throw new IllegalArgumentException("XPATH support not enabled.");
        }
        this.xpath = xpath;
        this.evaluator = XPATH_EVALUATOR_FACTORY.create(xpath);
    }

    @Override
    public Object evaluate(Filterable message) throws FilterException {
        return this.evaluator.evaluate(message) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString() {
        return "XPATH " + ConstantExpression.encodeString(this.xpath);
    }

    @Override
    public boolean matches(Filterable message) throws FilterException {
        Object object = this.evaluate(message);
        return object == Boolean.TRUE;
    }

    protected static void setupFeatures(DocumentBuilderFactory factory) throws ParserConfigurationException {
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            String key = (String)prop.getKey();
            if (!key.startsWith(DOCUMENT_BUILDER_FACTORY_FEATURE_PREFIX)) continue;
            Boolean value = Boolean.valueOf((String)prop.getValue());
            factory.setFeature(key.substring(DOCUMENT_BUILDER_FACTORY_FEATURE_PREFIX.length()), value);
        }
    }

    static {
        XPATH_EVALUATOR_FACTORY = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            XPathExpression.setupFeatures(factory);
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        new JAXPXPathEvaluator("//root", builder).evaluate("<root></root>");
        try {
            XPATH_EVALUATOR_FACTORY = xpath -> new JAXPXPathEvaluator(xpath, builder);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static interface XPathEvaluator {
        public boolean evaluate(Filterable var1) throws FilterException;
    }

    public static interface XPathEvaluatorFactory {
        public XPathEvaluator create(String var1);
    }
}

