/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.tagvalue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagValue {
    private static final boolean DEBUG = false;
    protected static final boolean VALIDATION = true;
    private static Pattern tagPattern = Pattern.compile("^[A-Za-z][A-Za-z0-9_]*$");
    private static final String tval = "[^; \t\r\n]++";
    private static Pattern valuePattern = Pattern.compile("^(?:[^; \t\r\n]++(?:(?:(?:\r\n)?[\t ])++[^; \t\r\n]++)*+)?$");
    private Map<String, CharSequence> tagValues;
    protected Set<String> mandatoryTags = new HashSet<String>();
    protected Map<String, CharSequence> defaults = new HashMap<String, CharSequence>();
    private String stringRepresentation = null;

    protected Set<String> tagSet() {
        return this.tagValues.keySet();
    }

    protected boolean containsTag(String tag) {
        return this.tagValues.containsKey(tag);
    }

    protected CharSequence trimFWS(CharSequence data, int tStart, int tStop, boolean trimWSP) {
        while (tStart < tStop && (data.charAt(tStart) == ' ' || data.charAt(tStart) == '\t') || tStart < tStop - 2 && data.charAt(tStart) == '\r' && data.charAt(tStart + 1) == '\n' && (data.charAt(tStart + 2) == ' ' || data.charAt(tStart + 2) == '\t')) {
            if (data.charAt(tStart) == '\r') {
                tStart += 3;
                continue;
            }
            ++tStart;
        }
        while (tStart < tStop && (data.charAt(tStop) == ' ' || data.charAt(tStop) == '\t')) {
            if ((tStart > --tStop - 1 || data.charAt(tStop) != '\n' || data.charAt(tStop - 1) != '\r') && (tStart >= tStop || data.charAt(tStop) != ' ' && data.charAt(tStop) != '\t')) continue;
            if (data.charAt(tStop) == '\n') {
                tStop -= 2;
                continue;
            }
            --tStop;
        }
        if (trimWSP) {
            return this.trimWSP(data, tStart, tStop);
        }
        return data.subSequence(tStart, tStop + 1);
    }

    private CharSequence trimWSP(CharSequence data, int vStart, int vStop) {
        if (vStop < vStart - 1) {
            throw new IllegalArgumentException("Stop must be >= than start");
        }
        while (vStart <= vStop && (data.charAt(vStart) == ' ' || data.charAt(vStart) == '\t')) {
            ++vStart;
        }
        while (vStart <= vStop && (data.charAt(vStop) == ' ' || data.charAt(vStop) == '\t')) {
            --vStop;
        }
        return data.subSequence(vStart, vStop + 1);
    }

    public TagValue(String data) {
        this.tagValues = this.newTagValue();
        this.init();
        this.parse(data);
    }

    protected Map<String, CharSequence> newTagValue() {
        return new HashMap<String, CharSequence>();
    }

    protected void init() {
    }

    protected void parse(String data) {
        for (int i = 0; i < data.length(); ++i) {
            int equal = data.indexOf(61, i);
            if (equal == -1) {
                String rest = data.substring(i);
                if (rest.length() > 0 && this.trimFWS(rest, 0, rest.length() - 1, true).length() > 0) {
                    throw new IllegalStateException("Unexpected termination at position " + i + ": " + data + " | [" + rest + "]");
                }
                i = data.length();
                continue;
            }
            int next = data.indexOf(59, i);
            if (next == -1) {
                next = data.length();
            }
            if (equal > next) {
                throw new IllegalStateException("Found ';' before '=' in " + data);
            }
            String tag = ((Object)this.trimFWS(data, i, equal - 1, true)).toString();
            if (!tagPattern.matcher(tag).matches()) {
                throw new IllegalStateException("Syntax error in tag: " + tag);
            }
            String tagString = tag.toString();
            if (this.tagValues.containsKey(tagString)) {
                throw new IllegalStateException("Syntax error (duplicate tag): " + tag);
            }
            CharSequence value = this.trimFWS(data, equal + 1, next - 1, true);
            if (!valuePattern.matcher(value).matches()) {
                throw new IllegalStateException("Syntax error in value: " + value);
            }
            this.tagValues.put(tagString, value);
            i = next;
        }
        this.stringRepresentation = data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tagValues == null ? 0 : ((Object)this.tagValues).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagValue other = (TagValue)obj;
        return !(this.tagValues == null ? other.tagValues != null : !((Object)this.tagValues).equals(other.tagValues));
    }

    public Set<String> getTags() {
        return this.tagValues.keySet();
    }

    protected CharSequence getValue(String key) {
        CharSequence val = this.tagValues.get(key);
        if (val == null) {
            return this.getDefault(key);
        }
        return val;
    }

    protected void setValue(String tag, String value) {
        this.stringRepresentation = null;
        this.tagValues.put(tag, value);
    }

    protected CharSequence getDefault(String key) {
        return this.defaults.get(key);
    }

    public void validate() {
        for (String tag : this.mandatoryTags) {
            if (this.getValue(tag) != null) continue;
            throw new IllegalStateException("Missing mandatory tag: " + tag);
        }
    }

    protected List<CharSequence> stringToColonSeparatedList(String h, Pattern pattern) {
        ArrayList<CharSequence> headers = new ArrayList<CharSequence>();
        for (int i = 0; i < h.length(); ++i) {
            CharSequence cs;
            int p = h.indexOf(58, i);
            if (p == -1) {
                p = h.length();
            }
            if (!pattern.matcher(cs = this.trimFWS(h, i, p - 1, false)).matches()) {
                throw new IllegalStateException("Syntax error in field name: " + cs);
            }
            headers.add(cs);
            i = p;
        }
        return headers;
    }

    protected boolean isInListCaseInsensitive(CharSequence hash, List<CharSequence> hashes) {
        for (CharSequence suppHash : hashes) {
            if (!((Object)hash).toString().equalsIgnoreCase(((Object)suppHash).toString())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.updateStringRepresentation();
        }
        return this.stringRepresentation;
    }

    private void updateStringRepresentation() {
        StringBuilder res = new StringBuilder();
        Set<String> s = this.getTags();
        for (String tag : s) {
            res.append(" ");
            res.append(tag);
            res.append("=");
            res.append(this.getValue(tag));
            res.append(";");
        }
        this.stringRepresentation = res.toString();
    }
}

