/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionInfo;
import com.unboundid.ldap.sdk.LDAPConnectionLogger;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.PasswordProvider;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SimpleBindRequest
extends BindRequest
implements ResponseAcceptor,
ProtocolOp {
    private static final byte CRED_TYPE_SIMPLE = -128;
    @NotNull
    private static final ASN1OctetString NO_BIND_DN = new ASN1OctetString();
    @NotNull
    private static final ASN1OctetString NO_PASSWORD = new ASN1OctetString(-128);
    private static final long serialVersionUID = 4725871243149974407L;
    private int messageID = -1;
    @NotNull
    private final ASN1OctetString bindDN;
    @Nullable
    private final ASN1OctetString password;
    @NotNull
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    @Nullable
    private final PasswordProvider passwordProvider;

    public SimpleBindRequest() {
        this(NO_BIND_DN, NO_PASSWORD, null, NO_CONTROLS);
    }

    public SimpleBindRequest(@Nullable String bindDN, @Nullable String password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(@Nullable String bindDN, @Nullable byte[] password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(@Nullable DN bindDN, @Nullable String password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(@Nullable DN bindDN, @Nullable byte[] password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(@Nullable String bindDN, @Nullable String password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN);
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(@Nullable String bindDN, @Nullable byte[] password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN);
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(@Nullable DN bindDN, @Nullable String password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN.toString());
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(@Nullable DN bindDN, @Nullable byte[] password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN.toString());
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(@NotNull String bindDN, @NotNull PasswordProvider passwordProvider, Control ... controls) {
        super(controls);
        this.bindDN = new ASN1OctetString(bindDN);
        this.passwordProvider = passwordProvider;
        this.password = null;
    }

    public SimpleBindRequest(@NotNull DN bindDN, @NotNull PasswordProvider passwordProvider, Control ... controls) {
        super(controls);
        this.bindDN = new ASN1OctetString(bindDN.toString());
        this.passwordProvider = passwordProvider;
        this.password = null;
    }

    private SimpleBindRequest(@Nullable ASN1OctetString bindDN, @Nullable ASN1OctetString password, @Nullable PasswordProvider passwordProvider, Control ... controls) {
        super(controls);
        this.bindDN = bindDN;
        this.password = password;
        this.passwordProvider = passwordProvider;
    }

    @NotNull
    public String getBindDN() {
        return this.bindDN.stringValue();
    }

    @Nullable
    public ASN1OctetString getPassword() {
        return this.password;
    }

    @Nullable
    public PasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    @Override
    public byte getProtocolOpType() {
        return 96;
    }

    @Override
    public void writeTo(@NotNull ASN1Buffer buffer) {
        ASN1BufferSequence requestSequence = buffer.beginSequence((byte)96);
        buffer.addElement(VERSION_ELEMENT);
        buffer.addElement(this.bindDN);
        if (this.passwordProvider == null) {
            buffer.addElement(this.password);
        } else {
            byte[] pwBytes;
            try {
                pwBytes = this.passwordProvider.getPasswordBytes();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new LDAPRuntimeException(le);
            }
            ASN1OctetString pw = new ASN1OctetString(-128, pwBytes);
            buffer.addElement(pw);
            buffer.setZeroBufferOnClear();
            Arrays.fill(pwBytes, (byte)0);
        }
        requestSequence.end();
    }

    @Override
    @NotNull
    public ASN1Element encodeProtocolOp() throws LDAPSDKUsageException {
        if (this.password == null) {
            throw new LDAPSDKUsageException(LDAPMessages.ERR_SIMPLE_BIND_ENCODE_PROTOCOL_OP_WITH_PROVIDER.get());
        }
        return new ASN1Sequence(96, new ASN1Integer(3), this.bindDN, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected BindResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        this.setReferralDepth(depth);
        if (this.password != null && this.bindDN.getValue().length > 0 && this.password.getValue().length == 0 && connection.getConnectionOptions().bindWithDNRequiresPassword()) {
            LDAPException le = new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_SIMPLE_BIND_DN_WITHOUT_PASSWORD.get());
            Debug.debugCodingError(le);
            throw le;
        }
        if (connection.synchronousMode()) {
            boolean autoReconnect = connection.getConnectionOptions().autoReconnect();
            return this.processSync(connection, autoReconnect);
        }
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        connection.registerResponseAcceptor(this.messageID, this);
        try {
            LDAPResponse response;
            long responseTimeout = this.getResponseTimeoutMillis(connection);
            Debug.debugLDAPRequest(Level.INFO, this, this.messageID, connection);
            LDAPConnectionLogger logger = connection.getConnectionOptions().getConnectionLogger();
            if (logger != null) {
                logger.logBindRequest((LDAPConnectionInfo)connection, this.messageID, this);
            }
            long requestTime = System.nanoTime();
            connection.getConnectionStatistics().incrementNumBindRequests();
            connection.sendMessage(message, responseTimeout);
            try {
                response = responseTimeout > 0L ? this.responseQueue.poll(responseTimeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_BIND_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            BindResult bindResult = this.handleResponse(connection, response, requestTime, false);
            return bindResult;
        }
        finally {
            connection.deregisterResponseAcceptor(this.messageID);
        }
    }

    @NotNull
    private BindResult processSync(@NotNull LDAPConnection connection, boolean allowRetry) throws LDAPException {
        LDAPResponse response;
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        long requestTime = System.nanoTime();
        Debug.debugLDAPRequest(Level.INFO, this, this.messageID, connection);
        LDAPConnectionLogger logger = connection.getConnectionOptions().getConnectionLogger();
        if (logger != null) {
            logger.logBindRequest((LDAPConnectionInfo)connection, this.messageID, this);
        }
        connection.getConnectionStatistics().incrementNumBindRequests();
        try {
            connection.sendMessage(message, this.getResponseTimeoutMillis(connection));
        }
        catch (LDAPException le) {
            BindResult bindResult;
            Debug.debugException(le);
            if (allowRetry && (bindResult = this.reconnectAndRetry(connection, le.getResultCode())) != null) {
                return bindResult;
            }
            throw le;
        }
        while ((response = connection.readResponse(this.messageID)) instanceof IntermediateResponse) {
            IntermediateResponseListener listener = this.getIntermediateResponseListener();
            if (listener == null) continue;
            listener.intermediateResponseReturned((IntermediateResponse)response);
        }
        return this.handleResponse(connection, response, requestTime, allowRetry);
    }

    @NotNull
    private BindResult handleResponse(@NotNull LDAPConnection connection, @Nullable LDAPResponse response, long requestTime, boolean allowRetry) throws LDAPException {
        BindResult retryResult;
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_SIMPLE_BIND_CLIENT_TIMEOUT.get(waitTime, this.messageID, this.bindDN.stringValue(), connection.getHostPort()));
        }
        connection.getConnectionStatistics().incrementNumBindResponses(System.nanoTime() - requestTime);
        if (response instanceof ConnectionClosedResponse) {
            BindResult retryResult2;
            if (allowRetry && (retryResult2 = this.reconnectAndRetry(connection, ResultCode.SERVER_DOWN)) != null) {
                return retryResult2;
            }
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), message));
        }
        BindResult bindResult = (BindResult)response;
        if (allowRetry && (retryResult = this.reconnectAndRetry(connection, bindResult.getResultCode())) != null) {
            return retryResult;
        }
        return bindResult;
    }

    @Nullable
    private BindResult reconnectAndRetry(@NotNull LDAPConnection connection, @NotNull ResultCode resultCode) {
        try {
            switch (resultCode.intValue()) {
                case 81: 
                case 84: 
                case 91: {
                    connection.reconnect();
                    return this.processSync(connection, false);
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return null;
    }

    @Override
    @NotNull
    public SimpleBindRequest getRebindRequest(@NotNull String host, int port) {
        return new SimpleBindRequest(this.bindDN, this.password, this.passwordProvider, this.getControls());
    }

    @Override
    @InternalUseOnly
    public void responseReceived(@NotNull LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    @NotNull
    public String getBindType() {
        return "SIMPLE";
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    @NotNull
    public SimpleBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public SimpleBindRequest duplicate(@Nullable Control[] controls) {
        SimpleBindRequest bindRequest = new SimpleBindRequest(this.bindDN, this.password, this.passwordProvider, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        bindRequest.setIntermediateResponseListener(this.getIntermediateResponseListener());
        bindRequest.setReferralDepth(this.getReferralDepth());
        bindRequest.setReferralConnector(this.getReferralConnectorInternal());
        return bindRequest;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SimpleBindRequest(dn='");
        buffer.append(this.bindDN);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(@NotNull List<String> lineList, @NotNull String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(3);
        constructorArgs.add(ToCodeArgHelper.createString(this.bindDN.stringValue(), "Bind DN"));
        constructorArgs.add(ToCodeArgHelper.createString("---redacted-password---", "Bind Password"));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "SimpleBindRequest", requestID + "Request", "new SimpleBindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

