/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.display;

import com.beetstra.jutf7.CharsetProvider;
import com.google.common.base.CharMatcher;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ModifiedUtf7 {
    private static final CharMatcher UNENCODED_CHAR_MATCHER = CharMatcher.isNot((char)'&');
    private static final Charset X_MODIFIED_UTF_7_CHARSET = new CharsetProvider().charsetForName("X-MODIFIED-UTF-7");

    public static String decodeModifiedUTF7(String input) {
        if (UNENCODED_CHAR_MATCHER.matchesAllOf((CharSequence)input)) {
            return input;
        }
        return X_MODIFIED_UTF_7_CHARSET.decode(ByteBuffer.wrap(input.getBytes())).toString();
    }

    public static String encodeModifiedUTF7(String input) {
        ByteBuffer encode = X_MODIFIED_UTF_7_CHARSET.encode(input);
        return new String(encode.array(), 0, encode.remaining());
    }
}

