/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.riot.thrift.VisitorStreamRowTRDF;
import org.apache.jena.riot.thrift.wire.RDF_PrefixDecl;
import org.apache.jena.riot.thrift.wire.RDF_Quad;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.riot.thrift.wire.RDF_Triple;

public class StreamRowTRDFPrinter
implements VisitorStreamRowTRDF {
    private static final boolean ONELINE = false;
    private final IndentedWriter out;

    public StreamRowTRDFPrinter(IndentedWriter out) {
        this.out = out;
    }

    @Override
    public void visit(RDF_Triple triple) {
        this.out.print("RDF_Triple");
        this.out.incIndent();
        this.gap();
        this.print(triple.getS());
        this.gap();
        this.print(triple.getP());
        this.gap();
        this.print(triple.getO());
        this.lineEnd();
        this.out.decIndent();
    }

    @Override
    public void visit(RDF_Quad quad) {
        this.out.print("RDF_Quad");
        this.out.incIndent();
        this.gap();
        this.print(quad.getS());
        this.gap();
        this.print(quad.getP());
        this.gap();
        this.print(quad.getO());
        if (quad.isSetG()) {
            this.gap();
            this.print(quad.getG());
        }
        this.lineEnd();
        this.out.decIndent();
    }

    @Override
    public void visit(RDF_PrefixDecl prefix) {
        this.out.printf("RDF_PrefixDecl (%s: %s)\n", prefix.getPrefix(), prefix.getUri());
    }

    private void gap() {
        this.out.println();
    }

    private void lineEnd() {
        this.out.println();
    }

    private void startRow() {
    }

    private void finishRow() {
    }

    private void print(RDF_Term term) {
        this.out.print(term.toString());
    }
}

