/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class StaxConverterLoader
implements TypeConverterLoader {
    private volatile StaxConverter staxConverter;

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        StaxConverterLoader.addTypeConverter(registry, InputStream.class, XMLStreamReader.class, false, (type, exchange, value) -> this.getStaxConverter().createInputStream((XMLStreamReader)value, exchange));
        StaxConverterLoader.addTypeConverter(registry, Reader.class, XMLStreamReader.class, false, (type, exchange, value) -> this.getStaxConverter().createReader((XMLStreamReader)value, exchange));
        StaxConverterLoader.addTypeConverter(registry, XMLEventReader.class, File.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLEventReader((File)value, exchange));
        StaxConverterLoader.addTypeConverter(registry, XMLEventReader.class, InputStream.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLEventReader((InputStream)value, exchange));
        StaxConverterLoader.addTypeConverter(registry, XMLEventReader.class, Reader.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLEventReader((Reader)value));
        StaxConverterLoader.addTypeConverter(registry, XMLEventReader.class, XMLStreamReader.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLEventReader((XMLStreamReader)value));
        StaxConverterLoader.addTypeConverter(registry, XMLEventReader.class, Source.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLEventReader((Source)value));
        StaxConverterLoader.addTypeConverter(registry, XMLEventWriter.class, OutputStream.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLEventWriter((OutputStream)value, exchange));
        StaxConverterLoader.addTypeConverter(registry, XMLEventWriter.class, Writer.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLEventWriter((Writer)value));
        StaxConverterLoader.addTypeConverter(registry, XMLEventWriter.class, Result.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLEventWriter((Result)value));
        StaxConverterLoader.addTypeConverter(registry, XMLStreamReader.class, File.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLStreamReader((File)value, exchange));
        StaxConverterLoader.addTypeConverter(registry, XMLStreamReader.class, InputStream.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLStreamReader((InputStream)value, exchange));
        StaxConverterLoader.addTypeConverter(registry, XMLStreamReader.class, Reader.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLStreamReader((Reader)value));
        StaxConverterLoader.addTypeConverter(registry, XMLStreamReader.class, String.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLStreamReader((String)value));
        StaxConverterLoader.addTypeConverter(registry, XMLStreamReader.class, Source.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLStreamReader((Source)value));
        StaxConverterLoader.addTypeConverter(registry, XMLStreamWriter.class, OutputStream.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLStreamWriter((OutputStream)value, exchange));
        StaxConverterLoader.addTypeConverter(registry, XMLStreamWriter.class, Writer.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLStreamWriter((Writer)value));
        StaxConverterLoader.addTypeConverter(registry, XMLStreamWriter.class, Result.class, false, (type, exchange, value) -> this.getStaxConverter().createXMLStreamWriter((Result)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private StaxConverter getStaxConverter() {
        if (this.staxConverter == null) {
            this.staxConverter = new StaxConverter();
        }
        return this.staxConverter;
    }
}

