/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms.pool;

public final class PooledSessionKey {
    private final boolean transacted;
    private final int ackMode;
    private int hash;

    public PooledSessionKey(boolean transacted, int ackMode) {
        this.transacted = transacted;
        this.ackMode = ackMode;
        this.hash = ackMode;
        if (transacted) {
            this.hash = 31 * this.hash + 1;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ackMode;
        result = 31 * result + this.hash;
        result = 31 * result + (this.transacted ? 1231 : 1237);
        return result;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public int getAckMode() {
        return this.ackMode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PooledSessionKey other = (PooledSessionKey)obj;
        if (this.hash != other.hash) {
            return false;
        }
        if (this.ackMode != other.ackMode) {
            return false;
        }
        return this.transacted == other.transacted;
    }
}

