/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DirectProducer.class);
    private final DirectEndpoint endpoint;

    public DirectProducer(DirectEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        DirectConsumer consumer = this.endpoint.getConsumer();
        if (consumer == null) {
            if (this.endpoint.isFailIfNoConsumers()) {
                throw new DirectConsumerNotAvailableException("No consumers available on endpoint: " + (Object)((Object)this.endpoint), exchange);
            }
            LOG.debug("message ignored, no consumers available on endpoint: {}", (Object)this.endpoint);
        } else {
            consumer.getProcessor().process(exchange);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            DirectConsumer consumer = this.endpoint.getConsumer();
            if (consumer == null) {
                if (this.endpoint.isFailIfNoConsumers()) {
                    exchange.setException((Throwable)((Object)new DirectConsumerNotAvailableException("No consumers available on endpoint: " + (Object)((Object)this.endpoint), exchange)));
                } else {
                    LOG.debug("message ignored, no consumers available on endpoint: {}", (Object)this.endpoint);
                }
                callback.done(true);
                return true;
            }
            return consumer.getAsyncProcessor().process(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }
}

