/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.project.ui.ExtIcon;
import org.netbeans.modules.project.ui.groups.Group;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class OpenProjectListSettings {
    private static OpenProjectListSettings INSTANCE = new OpenProjectListSettings();
    private static final String RECENT_PROJECTS_DISPLAY_NAMES = "RecentProjectsDisplayNames";
    private static final String RECENT_PROJECTS_DISPLAY_ICONS = "RecentProjectsIcons";
    private static final String LAST_OPEN_PROJECT_DIR = "lastOpenProjectDir";
    private static final String PROP_PROJECT_CATEGORY = "lastSelectedProjectCategory";
    private static final String PROP_PROJECT_TYPE = "lastSelectedProjectType";
    private static final String MAIN_PROJECT_URL = "mainProjectURL";
    private static final String OPEN_PROJECTS_URLS = "openProjectsURLs";
    private static final String OPEN_PROJECTS_DISPLAY_NAMES = "openProjectsDisplayNames";
    private static final String OPEN_PROJECTS_ICONS = "openProjectsIcons";
    private static final String OPEN_SUBPROJECTS = "openSubprojects";
    private static final String TRUST_AND_PRIME = "trustAndPrime";
    private static final String PROP_PROJECTS_FOLDER = "projectsFolder";
    private static final String RECENT_PROJECTS_URLS = "recentProjectsURLs";
    private static final String RECENT_TEMPLATES = "recentTemplates";
    public static final String PROP_CREATED_PROJECTS_FOLDER = "createdProjectsFolderInWizard";

    private OpenProjectListSettings() {
    }

    public static OpenProjectListSettings getInstance() {
        return INSTANCE;
    }

    protected final String putProperty(String key, String value, boolean notify) {
        String retval = this.getProperty(key);
        if (value != null) {
            this.getPreferences().put(key, value);
        } else {
            this.getPreferences().remove(key);
        }
        return retval;
    }

    protected final String getProperty(String key) {
        return this.getPreferences().get(key, null);
    }

    private String getGroupedProperty(String key) {
        return this.getPreferences(true).get(key, null);
    }

    private String putGroupedProperty(String key, String value, boolean notify) {
        Preferences prefs = this.getPreferences(true);
        String retval = prefs.get(key, null);
        if (value != null) {
            prefs.put(key, value);
        } else {
            prefs.remove(key);
        }
        return retval;
    }

    protected final List<URL> getURLList(String key, boolean allowGrouped) {
        List<String> strs = this.getStringList(key, allowGrouped);
        ArrayList<URL> toRet = new ArrayList<URL>();
        for (String val : strs) {
            try {
                toRet.add(new URL(val));
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return toRet;
    }

    protected final List<String> getStringList(String key, boolean allowGrouped) {
        Preferences pref = this.getPreferences(allowGrouped);
        int count = 0;
        String val = pref.get(key + "." + count, null);
        ArrayList<String> toRet = new ArrayList<String>();
        while (val != null) {
            toRet.add(val);
            val = pref.get(key + "." + ++count, null);
        }
        return toRet;
    }

    protected final List<ExtIcon> getIconList(String key, boolean allowGrouped) {
        Preferences pref = this.getPreferences(allowGrouped);
        int count = 0;
        byte[] val = pref.getByteArray(key + "." + count, null);
        ArrayList<ExtIcon> toRet = new ArrayList<ExtIcon>();
        while (val != null) {
            toRet.add(val.length > 0 ? new ExtIcon(val) : new ExtIcon());
            val = pref.getByteArray(key + "." + ++count, null);
        }
        return toRet;
    }

    protected final void setIconList(String basekey, List<ExtIcon> list, boolean allowGrouped) throws IOException {
        assert (list != null);
        Preferences pref = this.getPreferences(allowGrouped);
        int count = 0;
        String key = basekey + "." + count;
        String val = pref.get(key, null);
        Iterator<ExtIcon> it = list.iterator();
        while (val != null || it.hasNext()) {
            if (it.hasNext()) {
                byte[] data = it.next().getBytes();
                if (data == null) {
                    data = new byte[]{};
                }
                pref.putByteArray(key, data);
            } else {
                pref.remove(key);
            }
            key = basekey + "." + ++count;
            val = pref.get(key, null);
        }
    }

    protected final void setStringList(String basekey, List<String> list, boolean allowGrouped) {
        assert (list != null);
        Preferences pref = this.getPreferences(allowGrouped);
        int count = 0;
        String key = basekey + "." + count;
        String val = pref.get(key, null);
        Iterator<String> it = list.iterator();
        while (val != null || it.hasNext()) {
            if (it.hasNext()) {
                pref.put(key, it.next());
            } else {
                pref.remove(key);
            }
            key = basekey + "." + ++count;
            val = pref.get(key, null);
        }
    }

    protected final void setURLList(String basekey, List<URL> list, boolean allowGrouped) {
        assert (list != null);
        ArrayList<String> strs = new ArrayList<String>(list.size());
        for (URL url : list) {
            strs.add(url.toExternalForm());
        }
        this.setStringList(basekey, strs, allowGrouped);
    }

    protected final Preferences getPreferences() {
        return NbPreferences.forModule(OpenProjectListSettings.class);
    }

    protected final Preferences getPreferences(boolean allowGrouped) {
        Group act;
        if (allowGrouped && (act = Group.getActiveGroup()) != null) {
            return act.prefs().node(OpenProjectListSettings.class.getPackage().getName().replace(".", "/"));
        }
        return NbPreferences.forModule(OpenProjectListSettings.class);
    }

    public List<URL> getOpenProjectsURLs() {
        return this.getURLList(OPEN_PROJECTS_URLS, false);
    }

    public void setOpenProjectsURLs(List<URL> list) {
        this.setURLList(OPEN_PROJECTS_URLS, list, false);
    }

    public void setOpenProjectsURLsAsStrings(List<String> list) {
        this.setStringList(OPEN_PROJECTS_URLS, list, false);
    }

    public List<String> getOpenProjectsDisplayNames() {
        return this.getStringList(OPEN_PROJECTS_DISPLAY_NAMES, false);
    }

    public void setOpenProjectsDisplayNames(List<String> list) {
        this.setStringList(OPEN_PROJECTS_DISPLAY_NAMES, list, false);
    }

    public List<ExtIcon> getOpenProjectsIcons() {
        return this.getIconList(OPEN_PROJECTS_ICONS, false);
    }

    public void setOpenProjectsIcons(List<ExtIcon> list) {
        try {
            this.setIconList(OPEN_PROJECTS_ICONS, list, false);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    public boolean isOpenSubprojects() {
        return this.getPreferences().getBoolean(OPEN_SUBPROJECTS, false);
    }

    public void setOpenSubprojects(boolean openSubprojects) {
        this.getPreferences().putBoolean(OPEN_SUBPROJECTS, openSubprojects);
    }

    public boolean isTrustAndPrime() {
        return this.getPreferences().getBoolean(TRUST_AND_PRIME, false);
    }

    public void setTrustAndPrime(boolean openSubprojects) {
        this.getPreferences().putBoolean(TRUST_AND_PRIME, openSubprojects);
    }

    public URL getMainProjectURL() {
        String str = this.getProperty(MAIN_PROJECT_URL);
        if (str != null) {
            try {
                return new URL(str);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public void setMainProjectURL(URL mainProjectURL) {
        this.setMainProjectURL(mainProjectURL != null ? mainProjectURL.toString() : null);
    }

    public void setMainProjectURL(String mainProjectURL) {
        this.putProperty(MAIN_PROJECT_URL, mainProjectURL, true);
    }

    public String getLastOpenProjectDir() {
        String result = this.getGroupedProperty(LAST_OPEN_PROJECT_DIR);
        if (result == null) {
            result = this.getProjectsFolder(false).getAbsolutePath();
        }
        return result;
    }

    public void setLastOpenProjectDir(String path) {
        this.putGroupedProperty(LAST_OPEN_PROJECT_DIR, path, true);
    }

    public List<URL> getRecentProjectsURLs() {
        return this.getURLList(RECENT_PROJECTS_URLS, true);
    }

    public List<String> getRecentProjectsDisplayNames() {
        return this.getStringList(RECENT_PROJECTS_DISPLAY_NAMES, true);
    }

    public List<ExtIcon> getRecentProjectsIcons() {
        return this.getIconList(RECENT_PROJECTS_DISPLAY_ICONS, true);
    }

    public void setRecentProjectsURLs(List<URL> list) {
        this.setURLList(RECENT_PROJECTS_URLS, list, true);
    }

    public void setRecentProjectsDisplayNames(List<String> list) {
        this.setStringList(RECENT_PROJECTS_DISPLAY_NAMES, list, true);
    }

    public void setRecentProjectsIcons(List<ExtIcon> list) {
        try {
            this.setIconList(RECENT_PROJECTS_DISPLAY_ICONS, list, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public File getProjectsFolder(boolean create) {
        String result = this.getProperty(PROP_PROJECTS_FOLDER);
        if (result == null || !new File(result).exists()) {
            File f;
            String userPrjDir = System.getProperty("netbeans.projects.dir");
            if (userPrjDir != null && (f = new File(userPrjDir)).exists() && f.isDirectory()) {
                return FileUtil.normalizeFile(f);
            }
            if (Boolean.getBoolean("netbeans.full.hack")) {
                return FileUtil.normalizeFile(new File(System.getProperty("java.io.tmpdir", "")));
            }
            File defaultDir = FileSystemView.getFileSystemView().getDefaultDirectory();
            if (defaultDir != null && defaultDir.exists() && defaultDir.isDirectory()) {
                boolean created;
                String nbPrjDirName = NbBundle.getMessage(OpenProjectListSettings.class, "DIR_NetBeansProjects");
                File nbPrjDir = new File(defaultDir, nbPrjDirName);
                if (nbPrjDir.exists() && nbPrjDir.canWrite()) {
                    return nbPrjDir;
                }
                boolean bl = created = create && nbPrjDir.mkdir();
                if (created) {
                    this.getPreferences().put(PROP_CREATED_PROJECTS_FOLDER, nbPrjDir.getAbsolutePath());
                    return nbPrjDir;
                }
            }
            result = System.getProperty("user.home");
        }
        return FileUtil.normalizeFile(new File(result));
    }

    public void setProjectsFolder(File folder) {
        if (folder == null) {
            this.putProperty(PROP_PROJECTS_FOLDER, null, true);
        } else {
            this.putProperty(PROP_PROJECTS_FOLDER, folder.getAbsolutePath(), true);
        }
    }

    public List<String> getRecentTemplates() {
        return this.getStringList(RECENT_TEMPLATES, true);
    }

    public void setRecentTemplates(List<String> templateNames) {
        this.setStringList(RECENT_TEMPLATES, templateNames, true);
    }

    public String getLastSelectedProjectCategory() {
        return this.getGroupedProperty(PROP_PROJECT_CATEGORY);
    }

    public void setLastSelectedProjectCategory(String category) {
        this.putGroupedProperty(PROP_PROJECT_CATEGORY, category, true);
    }

    public String getLastSelectedProjectType() {
        return this.getGroupedProperty(PROP_PROJECT_TYPE);
    }

    public void setLastSelectedProjectType(String type) {
        this.putGroupedProperty(PROP_PROJECT_TYPE, type, true);
    }
}

