/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import opennlp.tools.langdetect.DefaultLanguageDetectorContextGenerator;
import opennlp.tools.langdetect.LanguageDetectorContextGenerator;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.normalizer.EmojiCharSequenceNormalizer;
import opennlp.tools.util.normalizer.NumberCharSequenceNormalizer;
import opennlp.tools.util.normalizer.ShrinkCharSequenceNormalizer;
import opennlp.tools.util.normalizer.TwitterCharSequenceNormalizer;
import opennlp.tools.util.normalizer.UrlCharSequenceNormalizer;

public class LanguageDetectorFactory
extends BaseToolFactory {
    public LanguageDetectorContextGenerator getContextGenerator() {
        return new DefaultLanguageDetectorContextGenerator(1, 3, EmojiCharSequenceNormalizer.getInstance(), UrlCharSequenceNormalizer.getInstance(), TwitterCharSequenceNormalizer.getInstance(), NumberCharSequenceNormalizer.getInstance(), ShrinkCharSequenceNormalizer.getInstance());
    }

    public static LanguageDetectorFactory create(String subclassName) throws InvalidFormatException {
        if (subclassName == null) {
            return new LanguageDetectorFactory();
        }
        try {
            LanguageDetectorFactory theFactory = ExtensionLoader.instantiateExtension(LanguageDetectorFactory.class, subclassName);
            theFactory.init();
            return theFactory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization threw an exception.";
            throw new InvalidFormatException(msg, e);
        }
    }

    public void init() {
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
    }
}

