/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight;

import java.io.IOException;
import java.util.Collection;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.preflight.Format;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class PreflightDocument
extends PDDocument {
    protected ValidationResult result = new ValidationResult(true);
    protected PreflightConfiguration config;
    protected PreflightContext context;
    protected final Format specification;

    public PreflightDocument(Format format) throws IOException {
        this(format, (PreflightConfiguration)null);
    }

    public PreflightDocument(COSDocument doc, Format format) {
        this(doc, format, null);
    }

    public PreflightDocument(Format format, PreflightConfiguration cfg) throws IOException {
        this(new COSDocument(), format, cfg);
    }

    public PreflightDocument(COSDocument doc, Format format, PreflightConfiguration cfg) {
        super(doc);
        this.specification = format;
        this.config = cfg;
        if (this.config == null) {
            this.initConfiguration(format);
        }
    }

    private void initConfiguration(Format format) {
        switch (format) {
            default: 
        }
        this.config = PreflightConfiguration.createPdfA1BConfiguration();
    }

    public ValidationResult getResult() {
        return this.result;
    }

    public void setResult(ValidationResult _result) {
        if (this.result != null) {
            this.result.mergeResult(_result);
        } else {
            this.result = _result != null ? _result : new ValidationResult(true);
        }
    }

    public void addValidationError(ValidationResult.ValidationError error) {
        if (error != null) {
            if (this.result == null) {
                this.result = new ValidationResult(error.isWarning());
            }
            this.result.addError(error);
        }
    }

    public PreflightContext getContext() {
        return this.context;
    }

    public void setContext(PreflightContext context) {
        this.context = context;
    }

    public void validate() throws ValidationException {
        this.context.setConfig(this.config);
        Collection<String> processes = this.config.getProcessNames();
        for (String name : processes) {
            ContextHelper.validateElement(this.context, name);
        }
    }

    public Format getSpecification() {
        return this.specification;
    }
}

