/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.util.Strings;

public class OwnAttributeResolver
implements Strings.Resolver {
    public static final String PREFIX = "this:";
    private final ThreadLocal<Set<String>> _stack = new ThreadLocal();
    private final ConfiguredObject<?> _object;
    private final ObjectMapper _objectMapper;

    public OwnAttributeResolver(ConfiguredObject<?> object) {
        this._object = object;
        this._objectMapper = ConfiguredObjectJacksonModule.newObjectMapper(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolve(String variable, Strings.Resolver resolver) {
        boolean clearStack = false;
        Set<String> currentStack = this._stack.get();
        if (currentStack == null) {
            currentStack = new HashSet<String>();
            this._stack.set(currentStack);
            clearStack = true;
        }
        try {
            if (variable.startsWith(PREFIX)) {
                String returnString;
                String attrName = variable.substring(PREFIX.length());
                if (currentStack.contains(attrName)) {
                    throw new IllegalArgumentException("The value of attribute " + attrName + " is defined recursively");
                }
                currentStack.add(attrName);
                Object returnVal = this._object.getAttribute(attrName);
                if (returnVal == null) {
                    returnString = null;
                } else if (returnVal instanceof Map || returnVal instanceof Collection) {
                    try {
                        StringWriter writer = new StringWriter();
                        this._objectMapper.writeValue((Writer)writer, returnVal);
                        returnString = writer.toString();
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else {
                    returnString = returnVal instanceof ConfiguredObject ? ((ConfiguredObject)returnVal).getId().toString() : returnVal.toString();
                }
                String string = returnString;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (clearStack) {
                this._stack.remove();
            }
        }
    }
}

