You can report a bug, submit a new feature enhancement recommendation, or commit codes by a pull request.

## Reporting Bug

 - Before reporting a bug, please search from google to confirm that you cannot find any hint on it.
 - Look at the [issues List](https://github.com/apache/shardingsphere/issues) to confirm this issue is not a duplicated one.
 - [Create](https://github.com/apache/shardingsphere/issues/new) a new issue.
 - Define a clear and descriptive title for the issue.
 - If a bug is reported, please provide information below:
       - Details for reproduce bug step by step. Include SQL, configuration, expected results, actual results and tracing log.
       - ShardingSphere and your OS version.
       - Source code that reproduce the bug on GitHub, can be linked here.
       - Stack trace if exception thrown.
       - Screenshot and animated gif to help bug reproduce if necessary.
       - Screenshot for CPU, Memory, Network and IO stat if performance issue.
 - If enhancement recommendation reported, please provide information below:
       - Details for enhancement behaviour.
       - Explain why this enhancement is general feature for most developers.
       - List similar features which already available in other product if possible. Both open source and commercial software are available.
 - Assign label after issue created. Label should be bug, enhancement, discussion and so on.
 - Please pay attention to the issue and provide more information during discuss.
 - Please close issue when it is resolved. If you don't close it, we will close it after 3 days。
 - If this issue has new information, please reopen it again. Please note, issue can reopen which only closed by yourself.

## Commit Pull Request

 - Please choose an interested issue, or create a new issue and then settle a correct label.
 - Reply a deadline message to pickup this issue. 
 - Find a mentor in [Core developers list](https://shardingsphere.apache.org/community/en/team/), he will give you feedback for design and implements.
 - Fork to your GitHub repo and begin to work.
 - Please follow [Development conventions](https://shardingsphere.apache.org/community/en/involved/conduct/code/), and complete check before pull request submit.
 - Submit a pull request to master branch when finished.
 - Mentor will do code review and discuss some details, include design, implement, performance and code style. Code will be merged until mentor accepted.
 - Finally, congratulations that you have become the official contributor for Apache ShardingSphere.
