/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.infra.metadata.database.schema;

import org.junit.jupiter.api.Test;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.jupiter.api.Assertions.assertTrue;

class HashColumnTest {
    
    @Test
    void assertEquals() {
        assertThat(new HashColumn("col", "tbl", false), not(new Object()));
        assertThat(new HashColumn("col", "tbl", false), is(new HashColumn("COL", "TBL", false)));
        assertThat(new HashColumn("col", "tbl", false), not(new HashColumn("col1", "tbl", false)));
        assertThat(new HashColumn("col", "tbl", false), not(new HashColumn("col", "tbl1", false)));
        HashColumn column1 = new HashColumn("col", "tbl", false);
        HashColumn column2 = new HashColumn("COL", "TBL", false);
        assertTrue(column1.equals(column2));
        assertTrue(column2.equals(column1));
    }
    
    @Test
    void assertHashCode() {
        assertThat(new HashColumn("col", "tbl", false).hashCode(), is(new HashColumn("COL", "TBL", false).hashCode()));
        assertThat(new HashColumn("col", "tbl", false).hashCode(), not(new HashColumn("different_col", "tbl", false).hashCode()));
    }
}
