/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.postgis;

import java.io.InputStream;
import java.sql.ResultSet;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.storage.sql.feature.BinaryEncoding;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.apache.sis.storage.sql.postgis.ExtendedInfo;
import org.apache.sis.storage.sql.postgis.RasterReader;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class RasterGetter
extends ValueGetter<GridCoverage> {
    private final CoordinateReferenceSystem defaultCRS;
    private final BinaryEncoding encoding;

    RasterGetter(CoordinateReferenceSystem defaultCRS, BinaryEncoding encoding) {
        super(GridCoverage.class);
        this.defaultCRS = defaultCRS;
        this.encoding = encoding;
    }

    @Override
    public GridCoverage getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws Exception {
        InputStream stream = source.getBinaryStream(columnIndex);
        if (stream != null && stmts instanceof ExtendedInfo) {
            stream = this.encoding.decode(stream);
            RasterReader reader = ((ExtendedInfo)stmts).getRasterReader();
            reader.defaultCRS = this.defaultCRS;
            return reader.readAsCoverage(reader.channel(stream));
        }
        return null;
    }
}

