/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Region;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.gui.internal.PropertyView;
import org.apache.sis.image.Colorizer;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.internal.shared.ColorModelFactory;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.map.coverage.RenderingWorkaround;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.logging.Logging;

final class ImageConverter
extends Task<Statistics[]> {
    private static final Colorizer MASK_TRANSPARENCY = Colorizer.forRanges(Map.of(NumberRange.create((int)0, (boolean)true, (int)0, (boolean)true), new Color[]{ColorModelFactory.TRANSPARENT}, NumberRange.create((int)1, (boolean)true, (int)1, (boolean)true), new Color[]{new Color(0x30FFFF00, true)}));
    private final RenderedImage source;
    private Rectangle sourceAOI;
    private int width;
    private int height;
    private int xpos;
    private int ypos;
    private final ImageView view;
    private int[] data;

    ImageConverter(RenderedImage source, Rectangle sourceAOI, ImageView view, Region canvas) {
        this.source = source;
        this.sourceAOI = sourceAOI;
        this.view = view;
        this.width = Numerics.clamp((long)Math.round(canvas.getWidth()));
        this.height = Numerics.clamp((long)Math.round(canvas.getHeight()));
    }

    public static void clear(ImageView view) {
        view.setImage(null);
        view.setUserData(null);
    }

    public boolean needsRun(boolean newAOI) {
        if (this.width <= 0 || this.height <= 0) {
            return false;
        }
        if (!newAOI && this.view.getUserData() == this.source) {
            Image image = this.view.getImage();
            double dx = (double)this.width - image.getWidth();
            double dy = (double)this.height - image.getHeight();
            if (dx >= 0.0 && dy >= 0.0 && (dx == 0.0 || dy == 0.0)) {
                this.view.setX(dx / 2.0);
                this.view.setY(dy / 2.0);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statistics[] call() {
        if (this.sourceAOI == null) {
            this.sourceAOI = ImageUtilities.getBounds((RenderedImage)this.source);
        }
        double scale = Math.min((double)this.width / (double)this.sourceAOI.width, (double)this.height / (double)this.sourceAOI.height);
        this.width = Numerics.clamp((long)Math.round(scale * (double)this.sourceAOI.width));
        this.xpos = (this.width - this.width) / 2;
        this.height = Numerics.clamp((long)Math.round(scale * (double)this.sourceAOI.height));
        this.ypos = (this.height - this.height) / 2;
        if (this.width <= 0 || this.height <= 0) {
            return null;
        }
        AffineTransform toCanvas = AffineTransform.getScaleInstance(scale, scale);
        toCanvas.translate(-this.sourceAOI.x, -this.sourceAOI.y);
        ImageProcessor processor = new ImageProcessor();
        Statistics[] statistics = processor.valueOfStatistics(this.source, (Shape)this.sourceAOI, (DoubleUnaryOperator[])null);
        RenderedImage image = processor.stretchColorRamp(this.source, Map.of("multStdDev", 3, "statistics", statistics));
        RenderedImage mask = this.getMask(processor);
        BufferedImage buffer = new BufferedImage(this.width, this.height, 3);
        Graphics2D graphics = buffer.createGraphics();
        try {
            graphics.drawRenderedImage(RenderingWorkaround.wrap((RenderedImage)image), toCanvas);
            if (mask != null) {
                graphics.drawRenderedImage(RenderingWorkaround.wrap((RenderedImage)mask), toCanvas);
            }
        }
        finally {
            graphics.dispose();
        }
        this.data = ((DataBufferInt)buffer.getRaster().getDataBuffer()).getData();
        return statistics;
    }

    private RenderedImage getMask(ImageProcessor processor) {
        Object mask = this.source.getProperty("org.apache.sis.Mask");
        if (mask instanceof RenderedImage) {
            try {
                processor.setColorizer(MASK_TRANSPARENCY);
                return processor.visualize((RenderedImage)mask);
            }
            catch (IllegalArgumentException e) {
                Logging.recoverableException((Logger)LogHandler.LOGGER, PropertyView.class, (String)"setImage", (Throwable)e);
            }
        }
        return null;
    }

    protected void succeeded() {
        WritableImage destination = null;
        if (this.data != null) {
            destination = (WritableImage)this.view.getImage();
            if (destination == null || destination.getWidth() != (double)this.width || destination.getHeight() != (double)this.height) {
                destination = new WritableImage(this.width, this.height);
            }
            PixelWriter writer = destination.getPixelWriter();
            writer.setPixels(0, 0, this.width, this.height, (PixelFormat)PixelFormat.getIntArgbPreInstance(), this.data, 0, this.width);
            this.data = null;
        }
        this.view.setImage(destination);
        this.view.setUserData((Object)this.source);
        this.view.setX((double)this.xpos);
        this.view.setY((double)this.ypos);
    }

    protected void failed() {
        this.data = null;
        ImageConverter.clear(this.view);
    }

    protected void cancelled() {
        this.data = null;
    }
}

