/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.system;

import java.util.EnumSet;
import java.util.logging.Level;
import org.apache.sis.pending.jdk.ScopedValue;

public enum Semaphores {
    NULL_FOR_EMPTY_COLLECTION,
    METADATA_ONLY,
    COMPARING_CONVERSION_OR_DERIVED_CRS,
    TRANSFORM_ENCLOSED_IN_OPERATION,
    SUSPEND_PARAMETER_CHECK,
    FINER_LOG_LEVEL_FOR_OBJECTS_CREATION,
    FINER_LOG_LEVEL_FOR_DEPRECATION;

    private static final ThreadLocal<EnumSet<Semaphores>> FLAGS;

    public final Level getLogLevel(Level usual) {
        return this.get() ? Level.FINER : usual;
    }

    public final boolean get() {
        EnumSet<Semaphores> s = FLAGS.get();
        return s != null && s.contains((Object)this);
    }

    public final boolean set() {
        EnumSet<Semaphores> s = FLAGS.get();
        if (s != null) {
            return s.add(this);
        }
        FLAGS.set(EnumSet.of(this));
        return true;
    }

    public final void clear() {
        EnumSet<Semaphores> s = FLAGS.get();
        if (s != null && s.remove((Object)this) && s.isEmpty()) {
            FLAGS.remove();
        }
    }

    public final void clearIfTrue(boolean reset) {
        if (reset) {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R, X extends Throwable> R execute(ScopedValue.CallableOp<R, X> method) throws X {
        EnumSet<Semaphores> s = FLAGS.get();
        if (s == null) {
            s = EnumSet.of(this);
            FLAGS.set(s);
        } else if (!s.add(this)) {
            return method.call();
        }
        try {
            R r = method.call();
            return r;
        }
        finally {
            s.remove((Object)this);
            if (s.isEmpty()) {
                FLAGS.remove();
            }
        }
    }

    static {
        FLAGS = new ThreadLocal();
    }
}

