/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.gdal.ErrorHandler;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.GDALStore;
import org.apache.sis.storage.gdal.GDALStoreProvider;
import org.apache.sis.storage.gdal.OpenFlag;
import org.apache.sis.util.resources.Errors;

final class Opener
implements Runnable {
    private static final Set<String> VSICURL = Set.of("http", "https", "ftp", "ftps");
    private final GDALStoreProvider owner;
    final MemorySegment handle;
    Arena[] arenasToClose;

    Opener(GDALStoreProvider owner, String url, String ... allowedDrivers) throws DataStoreException {
        this(owner, url, new OpenFlag[]{OpenFlag.RASTER, OpenFlag.VECTOR, OpenFlag.SHARED}, allowedDrivers, null, null);
    }

    Opener(GDALStoreProvider owner, String url, OpenFlag[] openFlags, String[] allowedDrivers, String[] driverOptions, String[] siblingFiles) throws DataStoreException {
        this.owner = owner;
        this.arenasToClose = new Arena[4];
        GDAL gdal = owner.GDAL();
        try (Arena arena = Arena.ofConfined();){
            this.handle = gdal.open.invokeExact(arena.allocateFrom(url), OpenFlag.mask(openFlags), GDAL.toNullTerminatedStrings(arena, allowedDrivers), GDAL.toNullTerminatedStrings(arena, driverOptions), GDAL.toNullTerminatedStrings(arena, siblingFiles));
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        if (GDAL.isNull(this.handle)) {
            ErrorHandler.throwOnFailure(null, "open");
            throw new DataStoreException(Errors.format((short)14, (Object)url));
        }
    }

    static String toURL(URI location, Path path, boolean fallback) {
        String url;
        String scheme = location.getScheme();
        if (path != null && "file".equalsIgnoreCase(scheme)) {
            url = path.toString();
        } else {
            url = location.toString();
            if (scheme != null && VSICURL.contains(scheme.toLowerCase(Locale.US))) {
                url = "/vsicurl/".concat(url);
            } else if (!fallback) {
                return null;
            }
        }
        return url;
    }

    static ProbeResult probeContent(GDALStoreProvider owner, StorageConnector connector) throws DataStoreException {
        GDAL gdal;
        URI location = (URI)connector.getStorageAs(URI.class);
        String url = location != null ? Opener.toURL(location, (Path)connector.getStorageAs(Path.class), true) : (String)connector.getStorageAs(String.class);
        if (url != null && (gdal = (GDAL)owner.tryGDAL(GDALStoreProvider.class, "probeContent").orElse(null)) != null) {
            try (Arena arena = Arena.ofConfined();){
                MemorySegment strPtr = arena.allocateFrom(url);
                MemorySegment driver = gdal.identifyDriver.invokeExact(strPtr, MemorySegment.NULL);
                if (!GDAL.isNull(driver)) {
                    strPtr = arena.allocateFrom("DMD_MIMETYPE");
                    MemorySegment mimeType = gdal.getMetadataItem.invokeExact(driver, strPtr, MemorySegment.NULL);
                    ProbeResult probeResult = new ProbeResult(true, GDAL.toString(mimeType), null);
                    return probeResult;
                }
            }
            catch (Throwable e) {
                throw GDAL.propagate(e);
            }
            finally {
                ErrorHandler.throwOnFailure(null, "probeContent");
            }
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RuntimeException error = null;
        try {
            this.owner.tryGDAL(GDALStore.class, "close").ifPresent(gdal -> {
                int err;
                try {
                    err = gdal.close.invokeExact(this.handle);
                }
                catch (Throwable e) {
                    throw GDAL.propagate(e);
                }
                if (err != 0) {
                    ErrorHandler.errorOccurred(err);
                }
            });
        }
        catch (RuntimeException e) {
            error = e;
        }
        finally {
            for (Arena arena : this.arenasToClose) {
                if (arena == null) continue;
                try {
                    arena.close();
                }
                catch (RuntimeException e) {
                    if (error == null) {
                        error = e;
                        continue;
                    }
                    error.addSuppressed(e);
                }
            }
            Arrays.fill(this.arenasToClose, null);
        }
        if (error != null) {
            throw error;
        }
    }
}

