/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.SubspaceNotSpecifiedException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.MemoryGridCoverageResource;
import org.apache.sis.storage.aggregate.ConcatenatedGridResource;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.storage.aggregate.GridSliceLocator;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.operation.TransformException;

final class ConcatenatedGridCoverage
extends GridCoverage {
    private final GridSliceLocator locator;
    private final int[] ranges;
    private final boolean isConverted;
    private ConcatenatedGridCoverage opposite;
    private final Cache<GridSlice, GridCoverage> coverages;
    private final double[] expectedResolution;
    private final MergeStrategy strategy;

    ConcatenatedGridCoverage(ConcatenatedGridResource source, GridSliceLocator locator, int[] ranges) {
        super(locator.gridGeometry, source.getSampleDimensions());
        this.ranges = ranges;
        this.locator = locator;
        this.isConverted = source.isConverted;
        this.strategy = source.mergeStrategy;
        this.coverages = new Cache(15, 2L, true);
        this.expectedResolution = this.gridGeometry.getResolution(true);
    }

    private ConcatenatedGridCoverage(ConcatenatedGridCoverage source, GridSliceLocator locator, List<SampleDimension> sampleDimensions, boolean converted) {
        super(source.getGridGeometry(), sampleDimensions);
        this.isConverted = converted;
        this.locator = locator;
        this.ranges = source.ranges;
        this.strategy = source.strategy;
        this.coverages = source.coverages;
        this.expectedResolution = source.expectedResolution;
    }

    protected synchronized GridCoverage createConvertedValues(boolean converted) {
        if (converted == this.isConverted) {
            return this;
        }
        if (this.opposite == null) {
            List<Object> sampleDimensions = null;
            for (GridSlice slice : this.locator.slices) {
                if (!(slice.resource instanceof MemoryGridCoverageResource)) continue;
                GridCoverage coverage = ((MemoryGridCoverageResource)slice.resource).getGridCoverage();
                coverage = coverage.forConvertedValues(converted);
                sampleDimensions = coverage.getSampleDimensions();
                break;
            }
            if (sampleDimensions == null) {
                sampleDimensions = new ArrayList<SampleDimension>(this.getSampleDimensions());
                sampleDimensions.replaceAll(b -> b.forConvertedValues(converted));
            }
            this.opposite = new ConcatenatedGridCoverage(this, this.locator, sampleDimensions, converted);
        }
        return this.opposite;
    }

    public RenderedImage render(GridExtent extent) {
        int[] selection;
        int count;
        if (extent == null) {
            extent = this.gridGeometry.getExtent();
        }
        if ((count = (selection = this.locator.find(extent)).length) == 1) {
            return this.render(this.locator.slices[selection[0]], extent);
        }
        DisjointExtentException failure = null;
        if (count > 0) {
            GridGeometry[] candidates;
            GridGeometry request;
            if (this.strategy == null) {
                throw new SubspaceNotSpecifiedException(Resources.format((short)79, this.locator.getDimensionName(extent), extent.getMedian(this.locator.searchDimension), count));
            }
            try {
                request = new GridGeometry(this.getGridGeometry(), extent, null);
                candidates = new GridGeometry[count];
                for (int i = 0; i < count; ++i) {
                    int j = selection[i];
                    GridSlice slice = this.locator.slices[j];
                    candidates[i] = slice.resource.getGridGeometry();
                }
            }
            catch (DataStoreException | TransformException e) {
                throw new CannotEvaluateException(Resources.format((short)53), e);
            }
            TreeMap<GridSlice, RenderedImage> sources = new TreeMap<GridSlice, RenderedImage>();
            do {
                for (int i : this.strategy.filter(request, Arrays.copyOf(candidates, count))) {
                    try {
                        GridSlice slice = this.locator.slices[selection[i]];
                        if (sources.containsKey(slice)) continue;
                        sources.put(slice, this.render(slice, extent));
                    }
                    catch (DisjointExtentException e) {
                        if (failure == null) {
                            failure = e;
                        } else {
                            failure.addSuppressed((Throwable)e);
                        }
                        int remaining = --count - i;
                        System.arraycopy(candidates, i + 1, candidates, i, remaining);
                        System.arraycopy(selection, i + 1, selection, i, remaining);
                    }
                }
                if (sources.isEmpty()) continue;
                if (failure != null) {
                    Logging.ignorableException((Logger)ImageUtilities.LOGGER, ConcatenatedGridCoverage.class, (String)"render", (Throwable)failure);
                }
                return this.strategy.aggregate((RenderedImage[])sources.values().toArray(RenderedImage[]::new));
            } while (count > 0);
        }
        if (failure == null) {
            failure = new DisjointExtentException(this.gridGeometry.getExtent(), extent, this.locator.searchDimension);
        }
        throw failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderedImage render(GridSlice slice, GridExtent extent) {
        int[] subdim = extent.getSubspaceDimensions(2);
        GridCoverage coverage = (GridCoverage)this.coverages.peek((Object)slice);
        if (coverage == null) {
            try {
                Cache.Handler handler = this.coverages.lock((Object)slice);
                try {
                    coverage = (GridCoverage)handler.peek();
                    if (coverage == null) {
                        coverage = slice.resource.read(this.gridGeometry, this.ranges);
                    }
                }
                finally {
                    handler.putAndUnlock((Object)coverage);
                }
                coverage = coverage.forConvertedValues(this.isConverted);
            }
            catch (DataStoreException e) {
                throw new CannotEvaluateException(Resources.format((short)78, slice.getIdentifier()), (Throwable)e);
            }
        }
        double[] resolution = coverage.getGridGeometry().getResolution(true);
        for (int i : subdim) {
            if (Numerics.equals((double)resolution[i], (double)this.expectedResolution[i])) continue;
            throw new CannotEvaluateException(Resources.format((short)84, ConcatenatedGridCoverage.resolution(this.expectedResolution, subdim), ConcatenatedGridCoverage.resolution(resolution, subdim), slice.getIdentifier()));
        }
        return slice.render(coverage, extent, subdim);
    }

    private static Double resolution(double[] resolution, int[] subdim) {
        return Math.hypot(resolution[subdim[0]], resolution[subdim[1]]);
    }
}

