/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.time.DateTimeException;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.TemporalOperation;
import org.apache.sis.filter.base.BinaryFunction;
import org.apache.sis.pending.geoapi.temporal.Period;
import org.apache.sis.pending.geoapi.temporal.TemporalOperatorName;
import org.apache.sis.temporal.TimeMethods;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;

class TemporalFilter<R, T>
extends BinaryFunction<R, T, T>
implements Filter<R>,
Optimization.OnFilter<R> {
    private static final long serialVersionUID = 8248634286785309435L;
    protected final TemporalOperation<T> operation;

    private TemporalFilter(TemporalOperation<T> operation, Expression<R, ? extends T> expression1, Expression<R, ? extends T> expression2) {
        super(expression1, expression2);
        this.operation = operation;
    }

    public static <R, V> TemporalFilter<R, ?> create(Class<V> type, TemporalOperation.Factory factory, Expression<R, ? extends V> expression1, Expression<R, ? extends V> expression2) {
        Class<? extends V> c1 = TemporalFilter.getValueClass(expression1, type);
        Class<? extends V> c2 = TemporalFilter.getValueClass(expression2, type);
        Class commonType = type;
        if (type.isInterface()) {
            for (Class c : Classes.findCommonInterfaces(c1, c2)) {
                if (!commonType.isAssignableFrom(c)) continue;
                commonType = c;
            }
        } else {
            Class c = Classes.findCommonClass(c1, c2);
            if (commonType.isAssignableFrom(c)) {
                commonType = c;
            }
        }
        TemporalOperation operation = factory.create(TimeMethods.forType((Class)commonType)).unique();
        assert (operation.comparators.type.isAssignableFrom(commonType)) : commonType;
        assert (commonType.isAssignableFrom(c1)) : c1;
        assert (commonType.isAssignableFrom(c2)) : c2;
        if (Period.class.isAssignableFrom(commonType)) {
            return new Periods<R, V>(operation, expression1, expression2);
        }
        if (operation.comparators.isDynamic) {
            return new TemporalFilter<R, V>(operation, expression1, expression2);
        }
        return new Instants<R, V>(operation, expression1, expression2);
    }

    private static <T> Class<? extends T> getValueClass(Expression<?, ? extends T> e, Class<T> type) {
        if (e instanceof FeatureExpression) {
            return ((FeatureExpression)e).getResultClass();
        }
        return type;
    }

    public final TemporalOperatorName getOperatorType() {
        return this.operation.getOperatorType();
    }

    @Override
    protected final char symbol() {
        return this.operation.symbol();
    }

    protected final Expression<R, ? extends T> cast(Expression<R, ?> effective) {
        return effective.toValueType(this.operation.comparators.type);
    }

    @Override
    public Filter<R> recreate(Expression<R, ?>[] effective) {
        return new TemporalFilter<R, T>(this.operation, this.cast(effective[0]), this.cast(effective[1]));
    }

    @Override
    public boolean test(R candidate) {
        Object right;
        Object left = this.expression1.apply(candidate);
        if (left != null && (right = this.expression2.apply(candidate)) != null) {
            try {
                if (left instanceof Period) {
                    if (right instanceof Period) {
                        return this.operation.evaluate((Period)left, (Period)right);
                    }
                    return this.operation.evaluate((Period)left, right);
                }
                if (right instanceof Period) {
                    return this.operation.evaluate(left, (Period)right);
                }
                return this.operation.evaluate(left, right);
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(Errors.format((short)205, left.getClass(), right.getClass()), e);
            }
        }
        return false;
    }

    private static final class Periods<R, T extends Period>
    extends TemporalFilter<R, T> {
        private static final long serialVersionUID = 7570449007668484459L;

        Periods(TemporalOperation<T> operation, Expression<R, ? extends T> expression1, Expression<R, ? extends T> expression2) {
            super(operation, expression1, expression2);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new Periods(this.operation, this.cast(effective[0]), this.cast(effective[1]));
        }

        @Override
        public boolean test(R candidate) {
            Period right;
            Period left = (Period)this.expression1.apply(candidate);
            if (left != null && (right = (Period)this.expression2.apply(candidate)) != null) {
                try {
                    return this.operation.evaluate(left, right);
                }
                catch (DateTimeException e) {
                    throw new IllegalArgumentException(Errors.format((short)205, (Object)left.getClass(), (Object)right.getClass()), e);
                }
            }
            return false;
        }
    }

    private static final class Instants<R, T>
    extends TemporalFilter<R, T> {
        private static final long serialVersionUID = -3176521794130878518L;

        Instants(TemporalOperation<T> operation, Expression<R, ? extends T> expression1, Expression<R, ? extends T> expression2) {
            super(operation, expression1, expression2);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new Instants(this.operation, this.cast(effective[0]), this.cast(effective[1]));
        }

        @Override
        public boolean test(R candidate) {
            Object right;
            Object left = this.expression1.apply(candidate);
            if (left != null && (right = this.expression2.apply(candidate)) != null) {
                try {
                    return this.operation.evaluate(left, right);
                }
                catch (DateTimeException e) {
                    throw new IllegalArgumentException(Errors.format((short)205, left.getClass(), right.getClass()), e);
                }
            }
            return false;
        }
    }
}

