/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.j2d;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.geometry.wrapper.j2d.MultiPolylines;
import org.apache.sis.geometry.wrapper.j2d.Polygon;
import org.apache.sis.geometry.wrapper.j2d.Polyline;
import org.opengis.referencing.operation.TransformException;

public class PathBuilder {
    private static final int DIMENSION = 2;
    private double[] coordinates = new double[100];
    private int size;
    private final List<Polyline> polylines = new ArrayList<Polyline>();

    private boolean isValidSize(int limit) {
        return this.size >= 0 && this.size <= limit && (this.size & 1) == 0;
    }

    public final void append(PathBuilder other) {
        if (other != null) {
            assert (other.size == 0);
            this.polylines.addAll(other.polylines);
        }
    }

    public final void append(double[] source, int limit, boolean reverse) throws TransformException {
        double py;
        double px;
        assert (limit >= 0 && (limit & 1) == 0) : limit;
        int offset = this.size;
        if (limit >= this.coordinates.length - offset) {
            this.coordinates = Arrays.copyOf(this.coordinates, Math.addExact(offset, Math.max(offset, limit)));
        }
        double[] coordinates = this.coordinates;
        if (offset != 0) {
            px = coordinates[offset - 2];
            py = coordinates[offset - 1];
        } else {
            py = Double.NaN;
            px = Double.NaN;
        }
        int i = 0;
        while (i < limit) {
            double x;
            double y;
            if (reverse) {
                y = source[limit - ++i];
                x = source[limit - ++i];
            } else {
                x = source[i++];
                y = source[i++];
            }
            if (x == px && y == py) continue;
            if (Double.isNaN(x) || Double.isNaN(y)) {
                if (offset != 0) {
                    this.size = this.filterChunk(coordinates, this.size, offset);
                    assert (this.isValidSize(offset)) : this.size;
                    this.createPolyline(false);
                    offset = 0;
                }
            } else {
                coordinates[offset++] = x;
                coordinates[offset++] = y;
            }
            px = x;
            py = y;
        }
        this.size = this.filterChunk(coordinates, this.size, offset);
        assert (this.isValidSize(offset)) : this.size;
    }

    protected int filterChunk(double[] coordinates, int lower, int upper) {
        return upper;
    }

    protected int filterFull(double[] coordinates, int upper) throws TransformException {
        return upper;
    }

    public final void createPolyline(boolean close) throws TransformException {
        this.size = this.filterFull(this.coordinates, this.size);
        assert (this.isValidSize(this.coordinates.length)) : this.size;
        if (this.size >= 4) {
            if (this.coordinates[0] == this.coordinates[this.size - 2] && this.coordinates[1] == this.coordinates[this.size - 1]) {
                this.size -= 2;
                close = true;
            }
            this.polylines.add(close ? new Polygon(this.coordinates, this.size) : new Polyline(this.coordinates, this.size));
        }
        this.size = 0;
    }

    public final Shape build() {
        switch (this.polylines.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.polylines.get(0);
            }
        }
        return new MultiPolylines((Polyline[])this.polylines.toArray(Polyline[]::new));
    }

    public final Shape snapshot() {
        return this.build();
    }

    public String toString() {
        return PathBuilder.toString(this.coordinates, this.size);
    }

    public static String toString(double[] coordinates, int size) {
        StringBuilder b = new StringBuilder(30).append('[');
        if (size >= 2) {
            b.append((float)coordinates[0]).append(", ").append((float)coordinates[1]);
            int n = size - 2;
            if (n >= 2) {
                b.append(", ");
                if (size >= 6) {
                    b.append(" \u2026 (").append(size / 2 - 2).append(" pts) \u2026 ");
                }
                b.append((float)coordinates[n]).append(", ").append((float)coordinates[n + 1]);
            }
        }
        return b.append(']').toString();
    }
}

