/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql.internal.shared;

import java.sql.JDBCType;
import java.util.Date;

final class TypeMapper {
    private static final TypeMapper[] TYPES = new TypeMapper[]{new TypeMapper(Boolean.class, JDBCType.BOOLEAN), new TypeMapper(Date.class, JDBCType.TIMESTAMP), new TypeMapper(Double.class, JDBCType.DOUBLE), new TypeMapper(Float.class, JDBCType.REAL), new TypeMapper(Long.class, JDBCType.BIGINT), new TypeMapper(Integer.class, JDBCType.INTEGER), new TypeMapper(Short.class, JDBCType.SMALLINT), new TypeMapper(Byte.class, JDBCType.TINYINT), new TypeMapper(Number.class, JDBCType.DECIMAL)};
    private final Class<?> classe;
    private final JDBCType type;

    private TypeMapper(Class<?> classe, JDBCType type) {
        this.classe = classe;
        this.type = type;
    }

    public static String keywordFor(Class<?> classe) {
        if (classe != null) {
            for (TypeMapper type : TYPES) {
                if (!type.classe.isAssignableFrom(classe)) continue;
                switch (type.type) {
                    case DOUBLE: {
                        return "DOUBLE PRECISION";
                    }
                    case TINYINT: {
                        return "SMALLINT";
                    }
                }
                return type.type.name();
            }
        }
        return null;
    }
}

