/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.temporal;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.pending.geoapi.temporal.IndeterminateValue;
import org.apache.sis.pending.geoapi.temporal.Instant;
import org.apache.sis.pending.geoapi.temporal.Period;
import org.apache.sis.pending.geoapi.temporal.TemporalOperatorName;
import org.apache.sis.temporal.GeneralDuration;
import org.apache.sis.temporal.TemporalObject;
import org.apache.sis.temporal.TimeMethods;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.temporal.TemporalPrimitive;

final class DefaultInstant
extends TemporalObject
implements Instant {
    private static final long serialVersionUID = 3898772638524283287L;
    static final DefaultInstant UNKNOWN = new DefaultInstant(null, IndeterminateValue.UNKNOWN);
    private final Temporal position;
    private final IndeterminateValue indeterminate;

    DefaultInstant(Temporal position, IndeterminateValue indeterminate) {
        this.position = position;
        this.indeterminate = indeterminate;
    }

    public static DefaultInstant castOrCopy(Instant other) {
        if (other == null || other instanceof DefaultInstant) {
            return (DefaultInstant)other;
        }
        IndeterminateValue indeterminate = other.getIndeterminatePosition().orElse(null);
        if (indeterminate == IndeterminateValue.UNKNOWN) {
            return UNKNOWN;
        }
        Temporal position = other.getPosition();
        if (indeterminate == null || indeterminate == IndeterminateValue.BEFORE || indeterminate == IndeterminateValue.AFTER) {
            Objects.requireNonNull(position);
        }
        return new DefaultInstant(position, indeterminate);
    }

    @Override
    public final Temporal getPosition() {
        if (this.indeterminate != IndeterminateValue.NOW) {
            return this.position;
        }
        return ZonedDateTime.now();
    }

    @Override
    public final Optional<IndeterminateValue> getIndeterminatePosition() {
        return Optional.ofNullable(this.indeterminate);
    }

    @Override
    public TemporalAmount distance(TemporalPrimitive other) {
        ArgumentChecks.ensureNonNull((String)"other", (Object)other);
        if (other instanceof Instant) {
            return GeneralDuration.distance(this, (Instant)other, false, true);
        }
        if (other instanceof Period) {
            Period p = (Period)other;
            TemporalAmount t = GeneralDuration.distance(this, p.getBeginning(), false, false);
            if (t == null && (t = GeneralDuration.distance(this, p.getEnding(), true, false)) == null) {
                return Duration.ZERO;
            }
            return t;
        }
        throw new DateTimeException(Errors.format((short)200, (Object)other.getClass()));
    }

    @Override
    public TemporalOperatorName findRelativePosition(TemporalPrimitive other) {
        ArgumentChecks.ensureNonNull((String)"other", (Object)other);
        if (other instanceof Instant) {
            return this.relativeToInstant((Instant)other);
        }
        if (other instanceof Period) {
            return this.relativeToPeriod((Period)other);
        }
        throw new DateTimeException(Errors.format((short)200, (Object)other.getClass()));
    }

    final TemporalOperatorName relativeToPeriod(Period other) {
        String erroneous;
        TemporalOperatorName relation = this.relativeToInstant(other.getBeginning());
        if (relation == TemporalOperatorName.BEFORE) {
            return relation;
        }
        if (relation == TemporalOperatorName.EQUALS) {
            return TemporalOperatorName.BEGINS;
        }
        if (relation == TemporalOperatorName.AFTER) {
            relation = this.relativeToInstant(other.getEnding());
            if (relation == TemporalOperatorName.AFTER) {
                return relation;
            }
            if (relation == TemporalOperatorName.EQUALS) {
                return TemporalOperatorName.ENDS;
            }
            if (relation == TemporalOperatorName.BEFORE) {
                return TemporalOperatorName.DURING;
            }
            erroneous = "ending";
        } else {
            erroneous = "beginning";
        }
        throw new DateTimeException(Errors.format((short)70, (Object)erroneous, (Object)((Object)relation)));
    }

    private TemporalOperatorName relativeToInstant(Instant other) {
        block11: {
            Temporal t2;
            TimeMethods<Object> comparators;
            Temporal t1;
            boolean canTestEqual;
            boolean canTestAfter;
            boolean canTestBefore;
            block13: {
                block14: {
                    block12: {
                        IndeterminateValue oip;
                        canTestBefore = true;
                        canTestAfter = true;
                        canTestEqual = true;
                        if (this.indeterminate != null && this.indeterminate != IndeterminateValue.NOW) {
                            canTestBefore = this.indeterminate == IndeterminateValue.BEFORE;
                            canTestAfter = this.indeterminate == IndeterminateValue.AFTER;
                            canTestEqual = false;
                        }
                        if ((oip = (IndeterminateValue)other.getIndeterminatePosition().orElse(null)) != null) {
                            if (oip != IndeterminateValue.NOW) {
                                canTestBefore &= oip == IndeterminateValue.AFTER;
                                canTestAfter &= oip == IndeterminateValue.BEFORE;
                                canTestEqual = false;
                            } else if (this.indeterminate == IndeterminateValue.NOW) {
                                return TemporalOperatorName.EQUALS;
                            }
                        }
                        if (!(canTestBefore | canTestAfter | canTestEqual)) break block11;
                        if (oip != IndeterminateValue.NOW) break block12;
                        t1 = this.position;
                        if (t1 == null) break block11;
                        comparators = TimeMethods.forType(t1.getClass());
                        t2 = comparators.now();
                        break block13;
                    }
                    t2 = other.getPosition();
                    if (t2 == null) break block11;
                    if (this.indeterminate != IndeterminateValue.NOW) break block14;
                    comparators = TimeMethods.forType(t2.getClass());
                    t1 = comparators.now();
                    break block13;
                }
                t1 = this.position;
                if (t1 == null) break block11;
                comparators = TimeMethods.forType(Classes.findCommonClass(t1.getClass(), t2.getClass()));
            }
            if (canTestBefore && comparators.isBefore.test(t1, t2)) {
                return TemporalOperatorName.BEFORE;
            }
            if (canTestAfter && comparators.isAfter.test(t1, t2)) {
                return TemporalOperatorName.AFTER;
            }
            if (canTestEqual && comparators.isEqual.test(t1, t2)) {
                return TemporalOperatorName.EQUALS;
            }
        }
        throw new DateTimeException(Errors.format((short)38));
    }

    public boolean equals(Object object, ComparisonMode mode) {
        Instant that;
        if (mode.equals((Object)ComparisonMode.STRICT)) {
            return this.equals(object);
        }
        if (object instanceof Instant && this.indeterminate == (that = (Instant)object).getIndeterminatePosition().orElse(null)) {
            if (this.indeterminate == IndeterminateValue.NOW || this.indeterminate == IndeterminateValue.UNKNOWN) {
                return true;
            }
            Temporal other = that.getPosition();
            if (Objects.equals(this.position, other)) {
                return true;
            }
            if (mode.isIgnoringMetadata()) {
                return TimeMethods.compareLenient(TimeMethods.Test.EQUAL, this.position, other);
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultInstant) {
            DefaultInstant that = (DefaultInstant)object;
            return this.indeterminate == that.indeterminate && Objects.equals(this.position, that.position) && this.equalIdentifiers(that);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.position, this.indeterminate});
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.indeterminate != null) {
            String id = this.indeterminate.identifier();
            if (id == null) {
                id = this.indeterminate.name();
            }
            s.append(id);
            if (this.position != null) {
                s.append(' ').append(this.position);
            }
        } else {
            s.append(this.position);
        }
        return s.toString();
    }
}

