/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import org.apache.sis.referencing.internal.Arithmetic;
import org.apache.sis.referencing.internal.shared.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

final class ScaleTransform
extends AbstractLinearTransform
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = 7236779710212360309L;
    private final double[] factors;
    private final Number[] numbers;
    private final int numDroppedDimensions;

    ScaleTransform(double[] factors) {
        this.factors = (double[])factors.clone();
        this.numbers = ScaleTransform.wrap(this.factors);
        this.numDroppedDimensions = 0;
    }

    private ScaleTransform(ScaleTransform other) {
        int dim = other.factors.length;
        this.factors = new double[dim];
        this.numbers = new Number[dim];
        for (int i = 0; i < dim; ++i) {
            this.factors[i] = 1.0 / other.factors[i];
            this.numbers[i] = Arithmetic.inverse(other.numbers[i]);
        }
        this.numDroppedDimensions = 0;
    }

    ScaleTransform(int numRow, int numCol, Number[] elements) {
        this.numDroppedDimensions = numCol - numRow;
        this.numbers = new Number[numRow - 1];
        this.factors = ScaleTransform.store(elements, this.numbers, i -> numCol * i + i);
    }

    static double[] store(Number[] source, Number[] target, IntUnaryOperator indices) {
        double[] values = new double[target.length];
        for (int i = 0; i < target.length; ++i) {
            Number value = source[indices.applyAsInt(i)];
            if (value == null) continue;
            values[i] = value.doubleValue();
            if (ExtendedPrecisionMatrix.isZero(value)) continue;
            target[i] = value;
        }
        return values;
    }

    @Override
    public Number[] getElementAsNumbers(boolean writable) {
        int numCol = this.getNumCol();
        Number[] elements = new Number[this.getNumRow() * numCol];
        for (int i = 0; i < this.numbers.length; ++i) {
            elements[numCol * i + i] = this.numbers[i];
        }
        elements[elements.length - 1] = 1;
        return elements;
    }

    @Override
    public int getSourceDimensions() {
        return this.factors.length + this.numDroppedDimensions;
    }

    @Override
    public int getTargetDimensions() {
        return this.factors.length;
    }

    @Override
    public final Number getElementOrNull(int row, int column) {
        int dstDim = this.numbers.length;
        int srcDim = dstDim + this.numDroppedDimensions;
        ArgumentChecks.ensureBetween((String)"row", (int)0, (int)dstDim, (int)row);
        ArgumentChecks.ensureBetween((String)"column", (int)0, (int)srcDim, (int)column);
        if (row == dstDim) {
            if (column == srcDim) {
                return 1;
            }
        } else if (row == column) {
            return this.numbers[row];
        }
        return null;
    }

    @Override
    public boolean isIdentity() {
        if (this.numDroppedDimensions != 0) {
            return false;
        }
        for (int i = 0; i < this.factors.length; ++i) {
            if (this.factors[i] == 1.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        this.transform(srcPts, srcOff, dstPts, dstOff, 1);
        return derivate ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int dstDim;
        int srcDim;
        if (srcPts == dstPts && IterationStrategy.suggest(srcOff, srcDim = (dstDim = this.factors.length) + this.numDroppedDimensions, dstOff, dstDim, numPts) != IterationStrategy.ASCENDING) {
            srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcDim);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            for (int i = 0; i < this.factors.length; ++i) {
                dstPts[dstOff++] = srcPts[srcOff++] * this.factors[i];
            }
            srcOff += this.numDroppedDimensions;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int dstDim;
        int srcDim;
        if (srcPts == dstPts && IterationStrategy.suggest(srcOff, srcDim = (dstDim = this.factors.length) + this.numDroppedDimensions, dstOff, dstDim, numPts) != IterationStrategy.ASCENDING) {
            srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcDim);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            for (int i = 0; i < this.factors.length; ++i) {
                dstPts[dstOff++] = (float)((double)srcPts[srcOff++] * this.factors[i]);
            }
            srcOff += this.numDroppedDimensions;
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            for (int i = 0; i < this.factors.length; ++i) {
                dstPts[dstOff++] = (float)(srcPts[srcOff++] * this.factors[i]);
            }
            srcOff += this.numDroppedDimensions;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            for (int i = 0; i < this.factors.length; ++i) {
                dstPts[dstOff++] = (double)srcPts[srcOff++] * this.factors[i];
            }
            srcOff += this.numDroppedDimensions;
        }
    }

    @Override
    protected final LinearTransform createInverse() throws NoninvertibleTransformException {
        if (this.numDroppedDimensions == 0) {
            return new ScaleTransform(this);
        }
        return super.createInverse();
    }

    @Override
    public Matrix derivative(DirectPosition point) {
        int n = this.factors.length;
        MatrixSIS matrix = Matrices.createZero(n, n + this.numDroppedDimensions);
        for (int i = 0; i < n; ++i) {
            matrix.setElement(i, i, this.factors[i]);
        }
        return matrix;
    }

    @Override
    protected int computeHashCode() {
        return Arrays.hashCode(this.factors) + 31 * super.computeHashCode();
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        ScaleTransform that = (ScaleTransform)object;
        return this.numDroppedDimensions == that.numDroppedDimensions && Arrays.equals(this.factors, that.factors) && Arrays.equals(this.numbers, that.numbers);
    }
}

