/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts2.showcase.validation;

import com.opensymphony.xwork2.validator.annotations.DateRangeFieldValidator;
import com.opensymphony.xwork2.validator.annotations.EmailValidator;
import com.opensymphony.xwork2.validator.annotations.FieldExpressionValidator;
import com.opensymphony.xwork2.validator.annotations.IntRangeFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.StringLengthFieldValidator;
import com.opensymphony.xwork2.validator.annotations.UrlValidator;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

import java.sql.Date;

/**
 * <!-- START SNIPPET: ajaxFormSubmit -->
 * Example Action that shows how forms can be validated and submitted via AJAX
 * only. Form-submit-and-page-reload functionality of browsers is not used for
 * this action.
 * <p>Some things to note:
 * <ul>
 *   <li>Depends on <code>json-plugin</code>.</li>
 *   <li>Requires <code>jsonValidationInterceptor</code> to be on stack.</li>
 *   <li>Uses result type <code>jsonActionRedirect</code>.</li>
 *   <li>Uses http parameters <code>struts.enableJSONValidation=true</code> and <code>struts.validateOnly=false</code>.</li>
 *   <li>Uses a customized theme to make sure html elements required as error containers are always present and easily selectable in JS.</li>
 *   <li>Uses some custom JS code depending on jQuery to issue AJAX request and to render errors in html.</li>
 *   <li>Shows visual feedback while waiting for AJAX response.</li>
 * </ul>
 * </p>
 *
 */
public class AjaxFormSubmitAction extends AbstractValidationActionSupport {

    private String requiredValidatorField = null;
    private String requiredStringValidatorField = null;
    private Integer integerValidatorField = null;
    private Date dateValidatorField = null;
    private String emailValidatorField = null;
    private String urlValidatorField = null;
    private String stringLengthValidatorField = null;
    private String regexValidatorField = null;
    private String fieldExpressionValidatorField = null;

    @Override
    public void validate() {
        if (hasFieldErrors()) {
            addActionError("Errors present!");
        }
    }

    public Date getDateValidatorField() {
        return dateValidatorField;
    }

    @DateRangeFieldValidator(
        min="01/01/1990",
        max="01/01/2000",
        message="must be a min 01-01-1990 max 01-01-2000 if supplied")
    @StrutsParameter
    public void setDateValidatorField(Date dateValidatorField) {
        this.dateValidatorField = dateValidatorField;
    }

    public String getEmailValidatorField() {
        return emailValidatorField;
    }

    @EmailValidator(message="must be a valid email if supplied")
    @StrutsParameter
    public void setEmailValidatorField(String emailValidatorField) {
        this.emailValidatorField = emailValidatorField;
    }

    public Integer getIntegerValidatorField() {
        return integerValidatorField;
    }

    @IntRangeFieldValidator(min="1", max="10", message="must be integer min 1 max 10 if supplied")
    @StrutsParameter
    public void setIntegerValidatorField(Integer integerValidatorField) {
        this.integerValidatorField = integerValidatorField;
    }

    public String getRegexValidatorField() {
        return regexValidatorField;
    }

    @RegexFieldValidator(
        regex="[^<>]+",
        message="regexValidatorField must match a regexp (.*\\.txt) if specified")
    @StrutsParameter
    public void setRegexValidatorField(String regexValidatorField) {
        this.regexValidatorField = regexValidatorField;
    }

    public String getRequiredStringValidatorField() {
        return requiredStringValidatorField;
    }

    @RequiredStringValidator(trim=true, message="required and must be string")
    @StrutsParameter
    public void setRequiredStringValidatorField(String requiredStringValidatorField) {
        this.requiredStringValidatorField = requiredStringValidatorField;
    }

    public String getRequiredValidatorField() {
        return requiredValidatorField;
    }

    @RequiredFieldValidator(message="required")
    @StrutsParameter
    public void setRequiredValidatorField(String requiredValidatorField) {
        this.requiredValidatorField = requiredValidatorField;
    }

    public String getStringLengthValidatorField() {
        return stringLengthValidatorField;
    }

    @StringLengthFieldValidator(
        minLength="2",
        maxLength="4",
        trim=true,
        message="must be a String of a specific greater than 1 less than 5 if specified")
    @StrutsParameter
    public void setStringLengthValidatorField(String stringLengthValidatorField) {
        this.stringLengthValidatorField = stringLengthValidatorField;
    }

    public String getFieldExpressionValidatorField() {
        return fieldExpressionValidatorField;
    }

	@FieldExpressionValidator(
        expression = "(fieldExpressionValidatorField == requiredValidatorField)",
        message = "must be the same as the Required Validator Field if specified")
    @StrutsParameter
    public void setFieldExpressionValidatorField(String fieldExpressionValidatorField) {
        this.fieldExpressionValidatorField = fieldExpressionValidatorField;
    }

    public String getUrlValidatorField() {
        return urlValidatorField;
    }

    @UrlValidator(message="must be a valid url if supplied")
    @StrutsParameter
    public void setUrlValidatorField(String urlValidatorField) {
        this.urlValidatorField = urlValidatorField;
    }
}

/**
 * <!-- END SNIPPET: ajaxFormSubmit -->
 */


