/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.api.model;

import java.net.URI;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.syncope.common.keymaster.client.api.model.Domain;

public class Neo4jDomain
extends Domain {
    private static final long serialVersionUID = 9223353502929953472L;
    private URI uri;
    private String username;
    private String password;
    private int maxConnectionPoolSize = 100;

    @Override
    protected String defaultContentFile() {
        return "defaultContent.neo4j.xml";
    }

    public URI getUri() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public void setMaxConnectionPoolSize(int maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.uri).append((Object)this.username).append((Object)this.password).append(this.maxConnectionPoolSize).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Neo4jDomain other = (Neo4jDomain)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.uri, (Object)other.uri).append((Object)this.username, (Object)other.username).append((Object)this.password, (Object)other.password).append(this.maxConnectionPoolSize, other.maxConnectionPoolSize).build();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append((Object)this.uri).append((Object)this.username).append((Object)this.password).append(this.maxConnectionPoolSize).build();
    }

    public static class Builder
    extends Domain.Builder<Neo4jDomain, Builder> {
        public Builder(String key) {
            super(new Neo4jDomain(), key);
        }

        public Builder uri(URI uri) {
            ((Neo4jDomain)this.domain).uri = uri;
            return this;
        }

        public Builder username(String username) {
            ((Neo4jDomain)this.domain).username = username;
            return this;
        }

        public Builder password(String password) {
            ((Neo4jDomain)this.domain).password = password;
            return this;
        }

        public Builder maxConnectionPoolSize(int maxConnectionPoolSize) {
            ((Neo4jDomain)this.domain).maxConnectionPoolSize = maxConnectionPoolSize;
            return this;
        }
    }
}

