/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.OptionalInt;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockTierStateMachine;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionState;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\u0013'\u0001-B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00039\u0011!a\u0004A!b\u0001\n\u0003i\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\u0015\u0003!Q1A\u0005\u0002uB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005}!A\u0001\n\u0001B\u0001B\u0003%\u0011\nC\u0003M\u0001\u0011\u0005Q\nC\u0004V\u0001\t\u0007I\u0011\u0002,\t\r5\u0004\u0001\u0015!\u0003X\u0011\u001dq\u0007\u00011A\u0005\n=Dqa\u001d\u0001A\u0002\u0013%A\u000f\u0003\u0004{\u0001\u0001\u0006K\u0001\u001d\u0005\u0006w\u0002!\t\u0001 \u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aq!!\f\u0001\t\u0003\ny\u0003C\u0004\u0002`\u0001!\t%!\u0019\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003\u000b\u0003A\u0011IAD\u0011\u001d\tY\t\u0001C!\u0003\u001bCq!a)\u0001\t\u0003\t)\u000bC\u0005\u00020\u0002\u0011\r\u0011\"\u0015\u00022\"A\u00111\u0017\u0001!\u0002\u0013\t9cB\u0005\u00026\u001a\n\t\u0011#\u0001\u00028\u001aAQEJA\u0001\u0012\u0003\tI\f\u0003\u0004M?\u0011\u0005\u0011\u0011\u0019\u0005\n\u0003\u0007|\u0012\u0013!C\u0001\u0003\u000bD\u0011\"a7 #\u0003%\t!!2\t\u0013\u0005uw$%A\u0005\u0002\u0005\u0015\u0007\"CAp?E\u0005I\u0011AAq\u0005EiunY6GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0006\u0003O!\naa]3sm\u0016\u0014(\"A\u0015\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\f\t\u0003[9j\u0011AJ\u0005\u0003_\u0019\u0012Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0001\u0006n_\u000e\\G*Z1eKJ,\u0012A\r\t\u0003[MJ!\u0001\u000e\u0014\u0003%5{7m\u001b'fC\u0012,'/\u00128e!>Lg\u000e^\u0001\f[>\u001c7\u000eT3bI\u0016\u0014\b%\u0001\u000bn_\u000e\\G+[3s'R\fG/Z'bG\"Lg.Z\u000b\u0002qA\u0011Q&O\u0005\u0003u\u0019\u0012A#T8dWRKWM]*uCR,W*Y2iS:,\u0017!F7pG.$\u0016.\u001a:Ti\u0006$X-T1dQ&tW\rI\u0001\ne\u0016\u0004H.[2b\u0013\u0012,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0004\u0013:$\u0018A\u0003:fa2L7-Y%eA\u0005AA.Z1eKJLE-A\u0005mK\u0006$WM]%eA\u0005qa-\u001a;dQ\n\u000b7m[(gM6\u001b\u0018\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\ti#*\u0003\u0002LM\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f9{\u0005+\u0015*T)B\u0011Q\u0006\u0001\u0005\u0006a-\u0001\rA\r\u0005\u0006m-\u0001\r\u0001\u000f\u0005\by-\u0001\n\u00111\u0001?\u0011\u001d)5\u0002%AA\u0002yBqaR\u0006\u0011\u0002\u0003\u0007a\bC\u0004I\u0017A\u0005\t\u0019A%\u0002-I,\u0007\u000f\\5dCB\u000b'\u000f^5uS>t7\u000b^1uKN,\u0012a\u0016\t\u00051v{&.D\u0001Z\u0015\tQ6,A\u0004nkR\f'\r\\3\u000b\u0005q\u0003\u0015AC2pY2,7\r^5p]&\u0011a,\u0017\u0002\u0004\u001b\u0006\u0004\bC\u00011i\u001b\u0005\t'B\u00012d\u0003\u0019\u0019w.\\7p]*\u0011\u0011\u0006\u001a\u0006\u0003K\u001a\fa!\u00199bG\",'\"A4\u0002\u0007=\u0014x-\u0003\u0002jC\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\u0017l\u0013\tagE\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\u0002/I,\u0007\u000f\\5dCB\u000b'\u000f^5uS>t7\u000b^1uKN\u0004\u0013A\u00057bi\u0016\u001cH/\u00129pG\"$UMZ1vYR,\u0012\u0001\u001d\t\u0004\u007fEt\u0014B\u0001:A\u0005\u0019y\u0005\u000f^5p]\u00061B.\u0019;fgR,\u0005o\\2i\t\u00164\u0017-\u001e7u?\u0012*\u0017\u000f\u0006\u0002vqB\u0011qH^\u0005\u0003o\u0002\u0013A!\u00168ji\"9\u0011pDA\u0001\u0002\u0004\u0001\u0018a\u0001=%c\u0005\u0019B.\u0019;fgR,\u0005o\\2i\t\u00164\u0017-\u001e7uA\u0005y1/\u001a;SKBd\u0017nY1Ti\u0006$X\rF\u0002v{~DQA`\tA\u0002}\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002\u0002E\u0001\rA[\u0001\u0006gR\fG/Z\u0001\u0016e\u0016\u0004H.[2b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\rQ\u0017q\u0001\u0005\u0006}J\u0001\raX\u0001\u000eC\u0012$\u0007+\u0019:uSRLwN\\:\u0015\r\u00055\u0011QCA\u0012!\u0015\ty!!\u0005`\u001b\u0005Y\u0016bAA\n7\n\u00191+\u001a;\t\u000f\u0005]1\u00031\u0001\u0002\u001a\u0005\u0011\u0012N\\5uS\u0006dg)\u001a;dQN#\u0018\r^3t!\u001d\ty!a\u0007`\u0003;I!AX.\u0011\u00075\ny\"C\u0002\u0002\"\u0019\u0012\u0011#\u00138ji&\fGNR3uG\"\u001cF/\u0019;f\u0011\u001d\t)c\u0005a\u0001\u0003O\tqBZ8sG\u0016$&/\u001e8dCRLwN\u001c\t\u0004\u007f\u0005%\u0012bAA\u0016\u0001\n9!i\\8mK\u0006t\u0017\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u00022\u0005\u001d\u0013\u0011JA*!\u0011y\u0014/a\r\u0011\t\u0005U\u00121I\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005\u0019An\\4\u000b\t\u0005u\u0012qH\u0001\nS:$XM\u001d8bYNT1!!\u0011d\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\u0012\u00028\tiAj\\4BaB,g\u000eZ%oM>DQA \u000bA\u0002}Cq!a\u0013\u0015\u0001\u0004\ti%A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bcA \u0002P%\u0019\u0011\u0011\u000b!\u0003\t1{gn\u001a\u0005\b\u0003+\"\u0002\u0019AA,\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!\u0011\u0011LA.\u001b\u0005\u0001\u0011bAA/]\tIa)\u001a;dQ\u0012\u000bG/Y\u0001\tiJ,hnY1uKR)Q/a\u0019\u0002f!)a0\u0006a\u0001?\"9\u0011qM\u000bA\u0002\u0005%\u0014a\u0004;sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u00075\nY'C\u0002\u0002n\u0019\u0012Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR)Q/a\u001d\u0002v!)aP\u0006a\u0001?\"9\u0011q\u000f\fA\u0002\u00055\u0013AB8gMN,G/A\u0006mCR,7\u000f^#q_\u000eDGc\u00019\u0002~!)ap\u0006a\u0001?\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0003BA'\u0003\u0007CQA \rA\u0002}\u000bA\u0002\\8h\u000b:$wJ\u001a4tKR$B!!\u0014\u0002\n\")a0\u0007a\u0001?\u0006\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\u0005=\u0015QTAP!\u0011y\u0014/!%\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1AYAL\u0015\t93-\u0003\u0003\u0002\u001c\u0006U%AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\u0006}j\u0001\ra\u0018\u0005\u0007\u0003CS\u0002\u0019\u0001 \u0002\u000b\u0015\u0004xn\u00195\u0002-Y,'/\u001b4z\u0019\u0006\u001cHOR3uG\",G-\u00129pG\"$R!^AT\u0003WCa!!+\u001c\u0001\u0004y\u0016!\u00039beRLG/[8o\u0011\u0019\tik\u0007a\u0001a\u0006iQ\r\u001f9fGR,G-\u00129pG\"\fq$[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3e+\t\t9#\u0001\u0011jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013!E'pG.4U\r^2iKJ$\u0006N]3bIB\u0011QfH\n\u0004?\u0005m\u0006cA \u0002>&\u0019\u0011q\u0018!\u0003\r\u0005s\u0017PU3g)\t\t9,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000fT3APAeW\t\tY\r\u0005\u0003\u0002N\u0006]WBAAh\u0015\u0011\t\t.a5\u0002\u0013Ut7\r[3dW\u0016$'bAAk\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0017q\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005\r(fA%\u0002J\u0002")
public class MockFetcherThread
extends AbstractFetcherThread {
    private final MockLeaderEndPoint mockLeader;
    private final MockTierStateMachine mockTierStateMachine;
    private final int replicaId;
    private final int leaderId;
    private final scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates;
    private Option<Object> latestEpochDefault;
    private final boolean isOffsetForLeaderEpochSupported;

    public static FailedPartitions $lessinit$greater$default$6() {
        return new FailedPartitions();
    }

    public static int $lessinit$greater$default$5() {
        return 0;
    }

    public static int $lessinit$greater$default$4() {
        return 1;
    }

    public static int $lessinit$greater$default$3() {
        return 0;
    }

    public MockLeaderEndPoint mockLeader() {
        return this.mockLeader;
    }

    public MockTierStateMachine mockTierStateMachine() {
        return this.mockTierStateMachine;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int leaderId() {
        return this.leaderId;
    }

    private scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates() {
        return this.replicaPartitionStates;
    }

    private Option<Object> latestEpochDefault() {
        return this.latestEpochDefault;
    }

    private void latestEpochDefault_$eq(Option<Object> x$1) {
        this.latestEpochDefault = x$1;
    }

    public void setReplicaState(TopicPartition topicPartition, PartitionState state) {
        this.replicaPartitionStates().put((Object)topicPartition, (Object)state);
    }

    public PartitionState replicaPartitionState(TopicPartition topicPartition) {
        return (PartitionState)this.replicaPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
        });
    }

    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates, boolean forceTruncation) {
        this.latestEpochDefault_$eq((Option<Object>)(forceTruncation ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)0))));
        Set partitions = super.addPartitions(initialFetchStates);
        this.latestEpochDefault_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        return partitions;
    }

    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        if (this.leader().isTruncationOnFetchSupported() && FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)partitionData)) {
            throw new IllegalStateException("processPartitionData should not be called for a partition with a diverging epoch.");
        }
        if (fetchOffset != state.logEndOffset()) {
            throw new RuntimeException(new StringBuilder(69).append("Offset mismatch for partition ").append(topicPartition).append(": ").append("fetched offset = ").append(fetchOffset).append(", log end offset = ").append(state.logEndOffset()).append(".").toString());
        }
        Iterable batches = CollectionConverters$.MODULE$.IterableHasAsScala(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala();
        LongRef maxTimestamp = LongRef.create((long)-1L);
        LongRef shallowOffsetOfMaxTimestamp = LongRef.create((long)-1L);
        LongRef lastOffset = LongRef.create((long)state.logEndOffset());
        ObjectRef lastEpoch = ObjectRef.create((Object)OptionalInt.empty());
        batches.foreach((Function1 & Serializable)batch -> {
            MockFetcherThread.$anonfun$processPartitionData$1(maxTimestamp, shallowOffsetOfMaxTimestamp, state, lastOffset, lastEpoch, batch);
            return BoxedUnit.UNIT;
        });
        state.logStartOffset_$eq(partitionData.logStartOffset());
        state.highWatermark_$eq(partitionData.highWatermark());
        return new Some((Object)new LogAppendInfo(fetchOffset, lastOffset.elem, (OptionalInt)lastEpoch.elem, maxTimestamp.elem, shallowOffsetOfMaxTimestamp.elem, Time.SYSTEM.milliseconds(), state.logStartOffset(), RecordValidationStats.EMPTY, CompressionType.NONE, FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData), BoxesRunTime.unboxToLong((Object)batches.headOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.lastOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L))));
    }

    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log_$eq((Buffer<RecordBatch>)((Buffer)state.log().takeWhile((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$truncate$1(truncationState, batch)))));
        state.logEndOffset_$eq(BoxesRunTime.unboxToLong((Object)state.log().lastOption().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$truncate$2(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> state.logStartOffset())));
        state.highWatermark_$eq(package$.MODULE$.min(state.highWatermark(), state.logEndOffset()));
    }

    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log().clear();
        if (state.rlmEnabled()) {
            state.localLogStartOffset_$eq(offset);
        } else {
            state.logStartOffset_$eq(offset);
        }
        state.logEndOffset_$eq(offset);
        state.highWatermark_$eq(offset);
    }

    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).log().lastOption().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partitionLeaderEpoch())).orElse((Function0 & Serializable)() -> this.latestEpochDefault());
    }

    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logStartOffset();
    }

    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logEndOffset();
    }

    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(topicPartition.partition()).setLeaderEpoch(epoch);
        OffsetForLeaderEpochResponseData.EpochEndOffset result = this.mockLeader().lookupEndOffsetForEpoch(topicPartition, epochData, this.replicaPartitionState(topicPartition));
        if (result.endOffset() == -1L) {
            return None$.MODULE$;
        }
        return new Some((Object)new OffsetAndEpoch(result.endOffset(), result.leaderEpoch()));
    }

    public void verifyLastFetchedEpoch(TopicPartition partition, Option<Object> expectedEpoch) {
        if (this.leader().isTruncationOnFetchSupported()) {
            Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)this.fetchState(partition).map((Function1 & Serializable)x$4 -> x$4.state()));
            Assertions.assertEquals(expectedEpoch, (Object)this.fetchState(partition).flatMap((Function1 & Serializable)x$5 -> x$5.lastFetchedEpoch()));
            return;
        }
    }

    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    public static final /* synthetic */ void $anonfun$processPartitionData$1(LongRef maxTimestamp$1, LongRef shallowOffsetOfMaxTimestamp$1, PartitionState state$1, LongRef lastOffset$1, ObjectRef lastEpoch$1, RecordBatch batch) {
        batch.ensureValid();
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            shallowOffsetOfMaxTimestamp$1.elem = batch.baseOffset();
        }
        state$1.log().append((Object)batch);
        state$1.logEndOffset_$eq(batch.nextOffset());
        lastOffset$1.elem = batch.lastOffset();
        lastEpoch$1.elem = OptionalInt.of(batch.partitionLeaderEpoch());
    }

    public static final /* synthetic */ boolean $anonfun$truncate$1(OffsetTruncationState truncationState$1, RecordBatch batch) {
        return batch.lastOffset() < truncationState$1.offset();
    }

    public static final /* synthetic */ long $anonfun$truncate$2(RecordBatch x$2) {
        return x$2.lastOffset() + 1L;
    }

    public MockFetcherThread(MockLeaderEndPoint mockLeader, MockTierStateMachine mockTierStateMachine, int replicaId, int leaderId, int fetchBackOffMs, FailedPartitions failedPartitions) {
        this.mockLeader = mockLeader;
        this.mockTierStateMachine = mockTierStateMachine;
        this.replicaId = replicaId;
        this.leaderId = leaderId;
        BrokerTopicStats x$7 = new BrokerTopicStats(false);
        boolean x$8 = true;
        super("mock-fetcher", "mock-fetcher", (LeaderEndPoint)mockLeader, failedPartitions, (TierStateMachine)mockTierStateMachine, fetchBackOffMs, x$8, x$7);
        this.replicaPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.latestEpochDefault = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        mockTierStateMachine.setFetcher(this);
        this.isOffsetForLeaderEpochSupported = true;
    }
}

