/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.suffix;

import com.googlecode.concurrenttrees.common.CharSequences;
import com.googlecode.concurrenttrees.common.KeyValuePair;
import com.googlecode.concurrenttrees.common.LazyIterator;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.util.PrettyPrintable;
import com.googlecode.concurrenttrees.suffix.SuffixTree;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentSuffixTree<O>
implements SuffixTree<O>,
PrettyPrintable,
Serializable {
    private final ConcurrentSuffixTreeImpl<Set<String>> radixTree;
    private final ConcurrentMap<String, O> valueMap;

    public ConcurrentSuffixTree(NodeFactory nodeFactory) {
        this.radixTree = new ConcurrentSuffixTreeImpl(nodeFactory);
        this.valueMap = new ConcurrentHashMap<String, O>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public O put(CharSequence key, O value) {
        if (key == null) {
            throw new IllegalArgumentException("The key argument was null");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("The key argument was zero-length");
        }
        if (value == null) {
            throw new IllegalArgumentException("The value argument was null");
        }
        this.radixTree.acquireWriteLock();
        try {
            String keyString = CharSequences.toString(key);
            O replacedValue = this.valueMap.put(keyString, value);
            if (replacedValue == null) {
                this.addSuffixesToRadixTree(keyString);
            }
            O o = replacedValue;
            return o;
        }
        finally {
            this.radixTree.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public O putIfAbsent(CharSequence key, O value) {
        this.radixTree.acquireWriteLock();
        try {
            String keyString = CharSequences.toString(key);
            O existingValue = this.valueMap.putIfAbsent(keyString, value);
            if (existingValue == null) {
                this.addSuffixesToRadixTree(keyString);
            }
            O o = existingValue;
            return o;
        }
        finally {
            this.radixTree.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(CharSequence key) {
        this.radixTree.acquireWriteLock();
        try {
            String keyString = CharSequences.toString(key);
            Object value = this.valueMap.get(keyString);
            if (value == null) {
                boolean bl = false;
                return bl;
            }
            this.removeSuffixesFromRadixTree(keyString);
            this.valueMap.remove(keyString);
            boolean bl = true;
            return bl;
        }
        finally {
            this.radixTree.releaseWriteLock();
        }
    }

    void addSuffixesToRadixTree(String keyAsString) {
        Iterable<CharSequence> suffixes = CharSequences.generateSuffixes(keyAsString);
        for (CharSequence suffix : suffixes) {
            Set<String> originalKeyRefs = (Set<String>)this.radixTree.getValueForExactKey(suffix);
            if (originalKeyRefs == null) {
                originalKeyRefs = this.createSetForOriginalKeys();
                this.radixTree.put(suffix, originalKeyRefs);
            }
            originalKeyRefs.add(keyAsString);
        }
    }

    void removeSuffixesFromRadixTree(String keyAsString) {
        Iterable<CharSequence> suffixes = CharSequences.generateSuffixes(keyAsString);
        for (CharSequence suffix : suffixes) {
            Set originalKeyRefs = (Set)this.radixTree.getValueForExactKey(suffix);
            originalKeyRefs.remove(keyAsString);
            if (!originalKeyRefs.isEmpty()) continue;
            this.radixTree.remove(suffix);
        }
    }

    protected Set<String> createSetForOriginalKeys() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Override
    public O getValueForExactKey(CharSequence key) {
        String keyString = CharSequences.toString(key);
        return (O)this.valueMap.get(keyString);
    }

    @Override
    public Iterable<CharSequence> getKeysEndingWith(CharSequence suffix) {
        Set originalKeys = (Set)this.radixTree.getValueForExactKey(suffix);
        if (originalKeys == null) {
            return Collections.emptySet();
        }
        Set results = originalKeys;
        return results;
    }

    @Override
    public Iterable<O> getValuesForKeysEndingWith(final CharSequence suffix) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new LazyIterator<O>(){
                    Iterator<String> originalKeys;
                    {
                        this.originalKeys = ConcurrentSuffixTree.nullSafeIterator((Iterable)ConcurrentSuffixTree.this.radixTree.getValueForExactKey(suffix));
                    }

                    @Override
                    protected O computeNext() {
                        Object value = null;
                        while (value == null) {
                            if (!this.originalKeys.hasNext()) {
                                return this.endOfData();
                            }
                            String originalKey = this.originalKeys.next();
                            value = ConcurrentSuffixTree.this.valueMap.get(originalKey);
                        }
                        return value;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<KeyValuePair<O>> getKeyValuePairsForKeysEndingWith(final CharSequence suffix) {
        return new Iterable<KeyValuePair<O>>(){

            @Override
            public Iterator<KeyValuePair<O>> iterator() {
                return new LazyIterator<KeyValuePair<O>>(){
                    Iterator<String> originalKeys;
                    {
                        this.originalKeys = ConcurrentSuffixTree.nullSafeIterator((Iterable)ConcurrentSuffixTree.this.radixTree.getValueForExactKey(suffix));
                    }

                    @Override
                    protected KeyValuePair<O> computeNext() {
                        String originalKey = null;
                        Object value = null;
                        while (value == null) {
                            if (!this.originalKeys.hasNext()) {
                                return (KeyValuePair)this.endOfData();
                            }
                            originalKey = this.originalKeys.next();
                            value = ConcurrentSuffixTree.this.valueMap.get(originalKey);
                        }
                        return new ConcurrentRadixTree.KeyValuePairImpl(originalKey, value);
                    }
                };
            }
        };
    }

    @Override
    public Iterable<CharSequence> getKeysContaining(final CharSequence fragment) {
        return new Iterable<CharSequence>(){

            @Override
            public Iterator<CharSequence> iterator() {
                return new LazyIterator<CharSequence>(){
                    Iterator<Set<String>> originalKeysSets;
                    Iterator<String> keyIterator;
                    Set<String> keysAlreadyProcessed;
                    {
                        this.originalKeysSets = ConcurrentSuffixTree.this.radixTree.getValuesForKeysStartingWith(fragment).iterator();
                        this.keyIterator = Collections.emptyList().iterator();
                        this.keysAlreadyProcessed = new HashSet<String>();
                    }

                    @Override
                    protected CharSequence computeNext() {
                        String nextKey = null;
                        while (nextKey == null) {
                            while (!this.keyIterator.hasNext()) {
                                if (!this.originalKeysSets.hasNext()) {
                                    return (CharSequence)this.endOfData();
                                }
                                this.keyIterator = this.originalKeysSets.next().iterator();
                            }
                            nextKey = this.keyIterator.next();
                            if (this.keysAlreadyProcessed.add(nextKey)) continue;
                            nextKey = null;
                        }
                        return nextKey;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<O> getValuesForKeysContaining(final CharSequence fragment) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new LazyIterator<O>(){
                    Iterator<Set<String>> originalKeysSets;
                    Iterator<String> keyIterator;
                    Set<String> keysAlreadyProcessed;
                    {
                        this.originalKeysSets = ConcurrentSuffixTree.this.radixTree.getValuesForKeysStartingWith(fragment).iterator();
                        this.keyIterator = Collections.emptyList().iterator();
                        this.keysAlreadyProcessed = new HashSet<String>();
                    }

                    @Override
                    protected O computeNext() {
                        Object value = null;
                        while (value == null) {
                            while (!this.keyIterator.hasNext()) {
                                if (!this.originalKeysSets.hasNext()) {
                                    return this.endOfData();
                                }
                                this.keyIterator = this.originalKeysSets.next().iterator();
                            }
                            String originalKey = this.keyIterator.next();
                            if (!this.keysAlreadyProcessed.add(originalKey)) continue;
                            value = ConcurrentSuffixTree.this.valueMap.get(originalKey);
                        }
                        return value;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<KeyValuePair<O>> getKeyValuePairsForKeysContaining(final CharSequence fragment) {
        return new Iterable<KeyValuePair<O>>(){

            @Override
            public Iterator<KeyValuePair<O>> iterator() {
                return new LazyIterator<KeyValuePair<O>>(){
                    Iterator<Set<String>> originalKeysSets;
                    Iterator<String> keyIterator;
                    Set<String> keysAlreadyProcessed;
                    {
                        this.originalKeysSets = ConcurrentSuffixTree.this.radixTree.getValuesForKeysStartingWith(fragment).iterator();
                        this.keyIterator = Collections.emptyList().iterator();
                        this.keysAlreadyProcessed = new HashSet<String>();
                    }

                    @Override
                    protected KeyValuePair<O> computeNext() {
                        String originalKey = null;
                        Object value = null;
                        while (value == null) {
                            while (!this.keyIterator.hasNext()) {
                                if (!this.originalKeysSets.hasNext()) {
                                    return (KeyValuePair)this.endOfData();
                                }
                                this.keyIterator = this.originalKeysSets.next().iterator();
                            }
                            originalKey = this.keyIterator.next();
                            if (!this.keysAlreadyProcessed.add(originalKey)) continue;
                            value = ConcurrentSuffixTree.this.valueMap.get(originalKey);
                        }
                        return new ConcurrentRadixTree.KeyValuePairImpl(originalKey, value);
                    }
                };
            }
        };
    }

    @Override
    public int size() {
        return this.valueMap.size();
    }

    static <T> Iterator<T> nullSafeIterator(Iterable<T> iterable) {
        return iterable == null ? Collections.emptyList().iterator() : iterable.iterator();
    }

    @Override
    public Node getNode() {
        return this.radixTree.getNode();
    }

    class ConcurrentSuffixTreeImpl<V>
    extends ConcurrentRadixTree<V> {
        public ConcurrentSuffixTreeImpl(NodeFactory nodeFactory) {
            super(nodeFactory);
        }

        @Override
        protected void acquireWriteLock() {
            super.acquireWriteLock();
        }

        @Override
        protected void releaseWriteLock() {
            super.releaseWriteLock();
        }
    }
}

