/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.clients;

import com.github.benmanes.caffeine.cache.Cache;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.pac4j.authentication.clients.BaseDelegatedIdentityProviderFactory;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.pac4j.core.client.BaseClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public class JdbcDelegatedIdentityProviderFactory
extends BaseDelegatedIdentityProviderFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcDelegatedIdentityProviderFactory.class);
    private static final String SQL_SELECT = "SELECT * FROM JdbcIdentityProviderEntity";
    protected final JdbcOperations jdbcTemplate;

    public JdbcDelegatedIdentityProviderFactory(JdbcOperations jdbcTemplate, CasConfigurationProperties casProperties, Collection<DelegatedClientFactoryCustomizer> customizers, CasSSLContext casSSLContext, Cache<String, Collection<BaseClient>> clientsCache, ConfigurableApplicationContext applicationContext) {
        super(casProperties, customizers, casSSLContext, clientsCache, applicationContext);
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    protected Collection<BaseClient> loadIdentityProviders() throws Exception {
        Optional bound;
        List<JdbcIdentityProviderEntity> configList = this.fetchIdentityProviderConfiguration();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (JdbcIdentityProviderEntity config : configList) {
            String property = config.toCasProperty();
            LOGGER.debug("Loading delegated identity provider configuration [{}]", (Object)property);
            properties.put(property, config.getValue());
        }
        if (!properties.isEmpty() && (bound = CasConfigurationProperties.bindFrom((String)this.getClass().getSimpleName(), properties)).isPresent()) {
            return this.buildAllIdentityProviders((CasConfigurationProperties)bound.get());
        }
        return List.of();
    }

    protected List<JdbcIdentityProviderEntity> fetchIdentityProviderConfiguration() {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(JdbcIdentityProviderEntity.class, true);
        return this.jdbcTemplate.query(SQL_SELECT, (RowMapper)rowMapper);
    }

    @Entity
    @Table(name="JdbcIdentityProviderEntity")
    public static class JdbcIdentityProviderEntity
    implements Serializable {
        public static final String TABLE_NAME = "JdbcIdentityProviderEntity";
        private static final String CONFIG_PREFIX = "cas.authn.pac4j";
        private static final long serialVersionUID = 976705073390152323L;
        @Id
        @GeneratedValue(strategy=GenerationType.IDENTITY)
        private long id;
        private String type;
        private int index;
        private String name;
        private String value;

        String toCasProperty() {
            return CONFIG_PREFIX + ".%s[%s].%s".formatted(this.getType(), this.getIndex(), this.getName());
        }

        @Generated
        public long getId() {
            return this.id;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public JdbcIdentityProviderEntity setId(long id) {
            this.id = id;
            return this;
        }

        @Generated
        public JdbcIdentityProviderEntity setType(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public JdbcIdentityProviderEntity setIndex(int index) {
            this.index = index;
            return this;
        }

        @Generated
        public JdbcIdentityProviderEntity setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public JdbcIdentityProviderEntity setValue(String value) {
            this.value = value;
            return this;
        }

        @Generated
        public String toString() {
            return "JdbcDelegatedIdentityProviderFactory.JdbcIdentityProviderEntity(id=" + this.id + ", type=" + this.type + ", index=" + this.index + ", name=" + this.name + ", value=" + this.value + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JdbcIdentityProviderEntity)) {
                return false;
            }
            JdbcIdentityProviderEntity other = (JdbcIdentityProviderEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            if (this.index != other.index) {
                return false;
            }
            String this$type = this.type;
            String other$type = other.type;
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.value;
            String other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JdbcIdentityProviderEntity;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.id;
            result = result * 59 + (int)($id >>> 32 ^ $id);
            result = result * 59 + this.index;
            String $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

