/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.handler.support;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.DelegatedAuthenticationPreProcessor;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.provision.DelegatedClientUserProfileProvisioner;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCoreProperties;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.pac4j.authentication.handler.support.BaseDelegatedClientAuthenticationHandler;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Monitorable
public class DelegatedClientAuthenticationHandler
extends BaseDelegatedClientAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientAuthenticationHandler.class);
    private final DelegatedIdentityProviders identityProviders;
    private final DelegatedClientUserProfileProvisioner profileProvisioner;
    private final ConfigurableApplicationContext applicationContext;

    public DelegatedClientAuthenticationHandler(Pac4jDelegatedAuthenticationCoreProperties properties, ServicesManager servicesManager, PrincipalFactory principalFactory, DelegatedIdentityProviders identityProviders, DelegatedClientUserProfileProvisioner profileProvisioner, SessionStore sessionStore, ConfigurableApplicationContext applicationContext) {
        super(properties.getName(), servicesManager, principalFactory, properties.getOrder(), sessionStore);
        this.identityProviders = identityProviders;
        this.profileProvisioner = profileProvisioner;
        this.applicationContext = applicationContext;
    }

    public boolean supports(Credential credential) {
        return credential != null && ClientCredential.class.isAssignableFrom(credential.getClass());
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws PreventedException {
        return (AuthenticationHandlerExecutionResult)FunctionUtils.doAndHandle(() -> {
            ClientCredential clientCredentials = (ClientCredential)credential;
            LOGGER.debug("Located client credentials as [{}]", (Object)clientCredentials);
            LOGGER.trace("Client name: [{}]", (Object)clientCredentials.getClientName());
            BaseClient client = this.identityProviders.findClient(clientCredentials.getClientName()).map(BaseClient.class::cast).orElseThrow(() -> new IllegalArgumentException("Unable to determine client based on client name " + clientCredentials.getClientName()));
            LOGGER.trace("Delegated client is: [{}]", (Object)client);
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext();
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext();
            JEEContext webContext = new JEEContext(Objects.requireNonNull(request), Objects.requireNonNull(response));
            Optional userProfileResult = Optional.ofNullable(clientCredentials.getUserProfile());
            if (userProfileResult.isEmpty()) {
                Credentials credentials = clientCredentials.getCredentials();
                CallContext callContext = new CallContext((WebContext)webContext, this.sessionStore);
                userProfileResult = client.getUserProfile(callContext, credentials);
            }
            UserProfile userProfile = userProfileResult.orElseThrow(() -> new PreventedException("Unable to fetch user profile from client " + client.getName()));
            LOGGER.debug("Final user profile is: [{}]", (Object)userProfile);
            userProfile.setClientName(clientCredentials.getClientName());
            this.storeUserProfile((WebContext)webContext, userProfile);
            return this.createResult(clientCredentials, userProfile, client, service);
        }, e -> {
            throw new PreventedException(e);
        }).get();
    }

    @Override
    protected void preFinalizeAuthenticationHandlerResult(ClientCredential credentials, Principal principal, UserProfile profile, BaseClient client, Service service) throws Throwable {
        this.profileProvisioner.execute(principal, profile, client, (Credential)credentials);
    }

    @Override
    protected Principal finalizeAuthenticationPrincipal(Principal initialPrincipal, BaseClient client, ClientCredential credential, Service service) throws Throwable {
        List processors = this.applicationContext.getBeansOfType(DelegatedAuthenticationPreProcessor.class).values().stream().filter(BeanSupplier::isNotProxy).collect(Collectors.toList());
        AnnotationAwareOrderComparator.sortIfNecessary(processors);
        Principal processingPrincipal = initialPrincipal;
        for (DelegatedAuthenticationPreProcessor processor : processors) {
            processingPrincipal = processor.process(processingPrincipal, client, (Credential)credential, service);
        }
        return processingPrincipal;
    }
}

