/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.form.autocomplete;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.renderer.ITextRenderer;
import org.wicketstuff.jquery.core.renderer.TextRenderer;
import org.wicketstuff.jquery.core.template.IJQueryTemplate;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.jquery.ui.form.autocomplete.AutoCompleteBehavior;
import org.wicketstuff.jquery.ui.form.autocomplete.AutoCompleteChoiceModelBehavior;
import org.wicketstuff.jquery.ui.form.autocomplete.IAutoCompleteListener;
import org.wicketstuff.jquery.ui.template.JQueryTemplateBehavior;

public abstract class AutoCompleteTextField<T extends Serializable>
extends TextField<T>
implements IJQueryWidget,
IAutoCompleteListener {
    private static final long serialVersionUID = 1L;
    private AutoCompleteChoiceModelBehavior<T> choiceModelBehavior;
    private final ITextRenderer<? super T> renderer;
    private final IConverter<T> converter;
    private final IJQueryTemplate template;
    private JQueryTemplateBehavior templateBehavior = null;
    private List<T> choices;

    public AutoCompleteTextField(String id) {
        this(id, (ITextRenderer<T>)new TextRenderer(), null);
    }

    public AutoCompleteTextField(String id, Class<T> type) {
        this(id, (ITextRenderer<T>)new TextRenderer(), type);
    }

    public AutoCompleteTextField(String id, ITextRenderer<? super T> renderer) {
        this(id, renderer, null);
    }

    public AutoCompleteTextField(String id, ITextRenderer<? super T> renderer, Class<T> type) {
        super(id, type);
        this.renderer = renderer;
        this.template = this.newTemplate();
        this.converter = this.newConverter();
    }

    public AutoCompleteTextField(String id, IModel<T> model) {
        this(id, model, (ITextRenderer<T>)new TextRenderer(), null);
    }

    public AutoCompleteTextField(String id, IModel<T> model, Class<T> type) {
        this(id, model, (ITextRenderer<T>)new TextRenderer(), type);
    }

    public AutoCompleteTextField(String id, IModel<T> model, ITextRenderer<? super T> renderer) {
        this(id, model, renderer, null);
    }

    public AutoCompleteTextField(String id, IModel<T> model, ITextRenderer<? super T> renderer, Class<T> type) {
        super(id, model, type);
        this.renderer = renderer;
        this.template = this.newTemplate();
        this.converter = this.newConverter();
    }

    private List<T> internalGetChoices(String input) {
        this.choices = this.getChoices(input);
        return this.choices;
    }

    protected abstract List<T> getChoices(String var1);

    protected final String getModelValue() {
        return this.renderer.getText(this.getModelObject());
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (!String.class.isAssignableFrom(this.getType()) && type != null && type.isAssignableFrom(this.getType())) {
            return this.converter;
        }
        return super.getConverter(type);
    }

    public String getTemplateToken() {
        if (this.templateBehavior != null) {
            return this.templateBehavior.getToken();
        }
        return null;
    }

    public ITextRenderer<? super T> getRenderer() {
        return this.renderer;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.choiceModelBehavior = this.newChoiceModelBehavior();
        this.add(new Behavior[]{this.choiceModelBehavior});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
        if (this.template != null) {
            this.templateBehavior = new JQueryTemplateBehavior(this.template);
            this.add(new Behavior[]{this.templateBehavior});
        }
    }

    public void onConfigure(JQueryBehavior behavior) {
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("autocomplete", (CharSequence)"off");
    }

    @Override
    public final void onSelect(AjaxRequestTarget target, int index) {
        if (-1 < index && index < this.choices.size()) {
            Serializable choice = (Serializable)this.choices.get(index);
            this.setModelObject(choice);
            this.onSelected(target);
        }
    }

    protected void onSelected(AjaxRequestTarget target) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new AutoCompleteBehavior(selector, (IAutoCompleteListener)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CharSequence getChoiceCallbackUrl() {
                return AutoCompleteTextField.this.choiceModelBehavior.getCallbackUrl();
            }

            protected String $() {
                if (AutoCompleteTextField.this.templateBehavior != null) {
                    String render = "jQuery('%s').data('ui-autocomplete')._renderItem = function( ul, item ) { var content = jQuery.tmpl(jQuery('#%s').html(), item);return jQuery('<li/>').data('ui-autocomplete-item', item).append(content).appendTo(ul);}";
                    return super.$() + String.format(render, this.selector, AutoCompleteTextField.this.templateBehavior.getToken());
                }
                return super.$();
            }
        };
    }

    protected IJQueryTemplate newTemplate() {
        return null;
    }

    private IConverter<T> newConverter() {
        return new IConverter<T>(){
            private static final long serialVersionUID = 1L;

            public T convertToObject(String value, Locale locale) {
                if (value != null && value.equals(AutoCompleteTextField.this.getModelValue())) {
                    return (Serializable)AutoCompleteTextField.this.getModelObject();
                }
                return null;
            }

            public String convertToString(T value, Locale locale) {
                return AutoCompleteTextField.this.renderer.getText(value);
            }
        };
    }

    private AutoCompleteChoiceModelBehavior<T> newChoiceModelBehavior() {
        return new AutoCompleteChoiceModelBehavior<T>(this.renderer, this.template){
            private static final long serialVersionUID = 1L;
            private static final String TERM = "term";

            public List<T> getChoices() {
                String input = RequestCycleUtils.getQueryParameterValue((String)TERM).toString();
                return AutoCompleteTextField.this.internalGetChoices(input);
            }
        };
    }
}

