/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.wizards.resources.AbstractConnConfPanel;
import org.apache.syncope.client.console.wizards.resources.ConnectorWizardBuilder;
import org.apache.syncope.common.lib.to.ConnIdBundle;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public abstract class ConnectorConfPanel
extends AbstractConnConfPanel<ConnInstanceTO> {
    private static final long serialVersionUID = -2025535531121434050L;
    private final List<ConnIdBundle> bundles;

    public ConnectorConfPanel(ConnInstanceTO connInstanceTO, List<ConnIdBundle> bundles) {
        super(connInstanceTO);
        this.bundles = bundles;
        this.model = new LoadableDetachableModel<List<ConnConfProperty>>(){
            private static final long serialVersionUID = -2965284931860212687L;

            protected List<ConnConfProperty> load() {
                List<ConnConfProperty> properties = ConnectorConfPanel.this.getConnProperties((ConnInstanceTO)ConnectorConfPanel.this.modelObject);
                ((ConnInstanceTO)ConnectorConfPanel.this.modelObject).getConf().clear();
                ((ConnInstanceTO)ConnectorConfPanel.this.modelObject).getConf().addAll(properties);
                return properties;
            }
        };
        this.setConfPropertyListView((IModel<List<ConnConfProperty>>)this.model, true);
    }

    @Override
    protected List<ConnConfProperty> getConnProperties(ConnInstanceTO instance) {
        return ConnectorWizardBuilder.getBundle(instance, this.bundles).getProperties().stream().map(key -> {
            ConnConfProperty property = new ConnConfProperty();
            property.setSchema(key);
            instance.getConf(key.getName()).ifPresent(conf -> {
                property.getValues().addAll(conf.getValues());
                property.setOverridable(conf.isOverridable());
            });
            if (property.getValues().isEmpty() && !key.getDefaultValues().isEmpty()) {
                property.getValues().addAll(key.getDefaultValues());
            }
            return property;
        }).collect(Collectors.toList());
    }
}

