/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.NotificationTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Notifications")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="notifications")
public interface NotificationService
extends JAXRSService {
    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public NotificationTO read(@NotNull @PathParam(value="key") String var1);

    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<NotificationTO> list();

    @ApiResponses(value={@ApiResponse(responseCode="201", description="Notification successfully created", headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="UUID generated for the entity created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the entity created")})})
    @POST
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull NotificationTO var1);

    @Parameter(name="key", description="Notification's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void update(@NotNull NotificationTO var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="key") String var1);

    @GET
    @Path(value="job")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public JobTO getJob();

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="job")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void actionJob(@QueryParam(value="action") JobAction var1);
}

