/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.notifications.sms;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.configuration.model.support.sms.RestfulSmsProperties;
import org.apereo.cas.notifications.sms.SmsSender;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class RestfulSmsSender
implements SmsSender {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final RestfulSmsProperties restProperties;
    private final HttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(String from, String to, String message) {
        boolean bl;
        HttpResponse response = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            ClientInfo holder = ClientInfoHolder.getClientInfo();
            if (holder != null) {
                parameters.put("clientIpAddress", holder.getClientIpAddress());
                parameters.put("serverIpAddress", holder.getServerIpAddress());
            }
            parameters.put("from", from);
            parameters.put("to", to);
            Map headers = CollectionUtils.wrap((String)"Content-Type", (Object)"application/json");
            headers.putAll(this.restProperties.getHeaders());
            HttpExecutionRequest.HttpExecutionRequestBuilder exec = HttpExecutionRequest.builder().basicAuthPassword(this.restProperties.getBasicAuthPassword()).basicAuthUsername(this.restProperties.getBasicAuthUsername()).method(HttpMethod.valueOf((String)this.restProperties.getMethod().toUpperCase(Locale.ENGLISH))).url(this.restProperties.getUrl()).httpClient(this.httpClient).headers(headers);
            exec = switch (this.restProperties.getStyle()) {
                default -> throw new MatchException(null, null);
                case RestfulSmsProperties.RestfulSmsRequestStyles.QUERY_PARAMETERS -> exec.parameters(parameters).entity(message);
                case RestfulSmsProperties.RestfulSmsRequestStyles.REQUEST_BODY -> {
                    parameters.put("text", message);
                    String body = (String)FunctionUtils.doUnchecked(() -> MAPPER.writeValueAsString((Object)parameters));
                    yield exec.entity(body);
                }
            };
            response = HttpUtils.execute((HttpExecutionRequest)exec.build());
            bl = response != null && HttpStatus.valueOf((int)response.getCode()).is2xxSuccessful();
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
        return bl;
    }

    @Generated
    public RestfulSmsSender(RestfulSmsProperties restProperties, HttpClient httpClient) {
        this.restProperties = restProperties;
        this.httpClient = httpClient;
    }
}

