/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.context.ComponentSourceAware;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowAdapter;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlowDefinition;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.dsl.context.IntegrationFlowContext;
import org.springframework.integration.dsl.context.StandardIntegrationFlowRegistration;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class StandardIntegrationFlowContext
implements IntegrationFlowContext,
BeanFactoryAware {
    private final Map<String, IntegrationFlowContext.IntegrationFlowRegistration> registry = new ConcurrentHashMap<String, IntegrationFlowContext.IntegrationFlowRegistration>();
    private final Map<String, Boolean> useFlowIdAsPrefix = new ConcurrentHashMap<String, Boolean>();
    private final Lock registerFlowsLock = new ReentrantLock();
    private DefaultListableBeanFactory beanFactory;

    StandardIntegrationFlowContext() {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(DefaultListableBeanFactory.class, (Object)beanFactory, (String)"To use Spring Integration Java DSL the 'beanFactory' has to be an instance of 'ConfigurableListableBeanFactory'. Consider using 'GenericApplicationContext' implementation.");
        this.beanFactory = (DefaultListableBeanFactory)beanFactory;
    }

    @Override
    public StandardIntegrationFlowRegistrationBuilder registration(IntegrationFlow integrationFlow2) {
        return new StandardIntegrationFlowRegistrationBuilder(integrationFlow2);
    }

    @Override
    public boolean isUseIdAsPrefix(String flowId) {
        return Boolean.TRUE.equals(this.useFlowIdAsPrefix.get(flowId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntegrationFlowContext.IntegrationFlowRegistration register(StandardIntegrationFlowRegistrationBuilder builder) {
        IntegrationFlow integrationFlow2 = builder.integrationFlow;
        String flowId = builder.id;
        this.registerFlowsLock.lock();
        try {
            if (flowId == null) {
                flowId = this.generateBeanName(integrationFlow2, null);
                builder.id(flowId);
            } else if (this.registry.containsKey(flowId)) {
                throw new IllegalArgumentException("An IntegrationFlow '" + String.valueOf(this.registry.get(flowId)) + "' with flowId '" + flowId + "' is already registered.\nAn existing IntegrationFlowRegistration must be destroyed before overriding.");
            }
            integrationFlow2 = this.registerFlowBean(integrationFlow2, flowId, builder.source, builder.description);
        }
        finally {
            this.registerFlowsLock.unlock();
        }
        builder.integrationFlow = integrationFlow2;
        String theFlowId = flowId;
        builder.additionalBeans.forEach((key, value) -> this.registerBean((Object)key, (String)value, theFlowId, builder.source, builder.description));
        StandardIntegrationFlowRegistration registration = new StandardIntegrationFlowRegistration(integrationFlow2, this, flowId);
        if (builder.autoStartup) {
            registration.start();
            builder.additionalBeans.keySet().stream().filter(SmartLifecycle.class::isInstance).filter(lifecycle -> ((SmartLifecycle)lifecycle).isAutoStartup()).forEach(lifecycle -> ((SmartLifecycle)lifecycle).start());
        }
        this.registry.put(flowId, registration);
        return registration;
    }

    private IntegrationFlow registerFlowBean(IntegrationFlow flow, @Nullable String beanName, @Nullable Object source, @Nullable String description) {
        IntegrationFlow flowToRegister = flow;
        if (!(flow instanceof StandardIntegrationFlow) && !(flow instanceof IntegrationFlowAdapter)) {
            flowToRegister = new IntegrationFlowComponentSourceAwareAdapter(flow);
        }
        return this.registerBean(flowToRegister, beanName, null, source, description);
    }

    private <B> B registerBean(B bean, @Nullable String beanNameArg, @Nullable String parentName, @Nullable Object source, @Nullable String description) {
        String beanName;
        String string = beanName = beanNameArg != null ? beanNameArg : this.generateBeanName(bean, parentName);
        if (parentName != null) {
            this.beanFactory.registerDependentBean(parentName, beanName);
        }
        if (bean instanceof ComponentSourceAware) {
            ComponentSourceAware componentSourceAware = (ComponentSourceAware)bean;
            if (source != null && componentSourceAware.getComponentSource() == null) {
                componentSourceAware.setComponentSource(source);
            }
            if (description != null && componentSourceAware.getComponentDescription() == null) {
                componentSourceAware.setComponentDescription(description);
            }
        }
        this.beanFactory.registerSingleton(beanName, bean);
        return (B)this.beanFactory.initializeBean(bean, beanName);
    }

    @Override
    @Nullable
    public IntegrationFlowContext.IntegrationFlowRegistration getRegistrationById(String flowId) {
        return this.registry.get(flowId);
    }

    @Override
    public void remove(String flowId) {
        IntegrationFlowContext.IntegrationFlowRegistration flowRegistration = this.registry.remove(flowId);
        if (flowRegistration == null) {
            throw new IllegalStateException("An IntegrationFlow with the id [" + flowId + "] doesn't exist in the registry.");
        }
        flowRegistration.stop();
        this.removeDependantBeans(flowId);
        this.beanFactory.destroySingleton(flowId);
    }

    private void removeDependantBeans(String parentName) {
        String[] dependentBeans;
        for (String beanName : dependentBeans = this.beanFactory.getDependentBeans(parentName)) {
            String[] aliases;
            this.beanFactory.destroyBean(this.beanFactory.getBean(beanName));
            this.beanFactory.destroySingleton(beanName);
            for (String alias : aliases = this.beanFactory.getAliases(beanName)) {
                this.beanFactory.removeAlias(alias);
            }
            this.removeDependantBeans(beanName);
        }
    }

    @Override
    public MessagingTemplate messagingTemplateFor(String flowId) {
        return this.registry.get(flowId).getMessagingTemplate();
    }

    @Override
    public Map<String, IntegrationFlowContext.IntegrationFlowRegistration> getRegistry() {
        return Collections.unmodifiableMap(this.registry);
    }

    private String generateBeanName(Object instance, @Nullable String parentName) {
        String generatedBeanName;
        String beanName;
        if (instance instanceof NamedComponent && (beanName = ((NamedComponent)instance).getBeanName()) != null) {
            return beanName;
        }
        String id = generatedBeanName = (parentName != null ? parentName : "") + instance.getClass().getName();
        int counter = -1;
        while (counter == -1 || this.beanFactory.containsBean(id)) {
            id = generatedBeanName + "#" + ++counter;
        }
        return id;
    }

    public final class StandardIntegrationFlowRegistrationBuilder
    implements IntegrationFlowContext.IntegrationFlowRegistrationBuilder {
        private final Map<Object, String> additionalBeans = new HashMap<Object, String>();
        private IntegrationFlow integrationFlow;
        private String id;
        private boolean autoStartup = true;
        private boolean idAsPrefix;
        @Nullable
        private Object source;
        @Nullable
        private String description;

        StandardIntegrationFlowRegistrationBuilder(IntegrationFlow integrationFlow2) {
            this.integrationFlow = integrationFlow2;
        }

        @Override
        public StandardIntegrationFlowRegistrationBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public StandardIntegrationFlowRegistrationBuilder autoStartup(boolean autoStartupToSet) {
            this.autoStartup = autoStartupToSet;
            return this;
        }

        @Override
        public StandardIntegrationFlowRegistrationBuilder addBean(Object bean) {
            return this.addBean(null, bean);
        }

        @Override
        public StandardIntegrationFlowRegistrationBuilder addBean(@Nullable String name, Object bean) {
            this.additionalBeans.put(bean, name);
            return this;
        }

        @Override
        public IntegrationFlowContext.IntegrationFlowRegistrationBuilder setSource(Object source) {
            this.source = source;
            return this;
        }

        @Override
        public IntegrationFlowContext.IntegrationFlowRegistrationBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public IntegrationFlowContext.IntegrationFlowRegistrationBuilder useFlowIdAsPrefix() {
            this.idAsPrefix = true;
            return this;
        }

        @Override
        public IntegrationFlowContext.IntegrationFlowRegistration register() {
            Assert.state((!this.idAsPrefix || StringUtils.hasText((String)this.id) ? 1 : 0) != 0, (String)"An 'id' must be present to use 'useFlowIdAsPrefix'");
            if (this.idAsPrefix) {
                StandardIntegrationFlowContext.this.useFlowIdAsPrefix.put(this.id, this.idAsPrefix);
            }
            IntegrationFlowContext.IntegrationFlowRegistration registration = StandardIntegrationFlowContext.this.register(this);
            registration.setBeanFactory((BeanFactory)StandardIntegrationFlowContext.this.beanFactory);
            return registration;
        }
    }

    private static final class IntegrationFlowComponentSourceAwareAdapter
    implements IntegrationFlow,
    ComponentSourceAware {
        private final IntegrationFlow delegate;
        private Object beanSource;
        private String beanDescription;

        IntegrationFlowComponentSourceAwareAdapter(IntegrationFlow delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setComponentSource(Object source) {
            this.beanSource = source;
        }

        @Override
        public Object getComponentSource() {
            return this.beanSource;
        }

        @Override
        public void setComponentDescription(String description) {
            this.beanDescription = description;
        }

        @Override
        public String getComponentDescription() {
            return this.beanDescription;
        }

        @Override
        @Nullable
        public String getBeanName() {
            return null;
        }

        public void setBeanName(String name) {
        }

        @Override
        public void configure(IntegrationFlowDefinition<?> flow) {
            this.delegate.configure(flow);
            StandardIntegrationFlow standardIntegrationFlow = ((IntegrationFlowBuilder)flow).get();
            if (this.beanSource != null) {
                standardIntegrationFlow.setComponentSource(this.beanSource);
            }
            if (this.beanDescription != null) {
                standardIntegrationFlow.setComponentDescription(this.beanDescription);
            }
        }
    }
}

