/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.Version;

public class VersionRange {
    public static final char LEFT_OPEN = '(';
    public static final char LEFT_CLOSED = '[';
    public static final char RIGHT_OPEN = ')';
    public static final char RIGHT_CLOSED = ']';
    private static final String ENDPOINT_DELIMITER = ",";
    private final Version floorVersion;
    private final boolean isFloorInclusive;
    private final Version ceilingVersion;
    private final boolean isCeilingInclusive;
    private final boolean empty;

    private static Version parseVersion(String version, String range) {
        try {
            return Version.parse(version);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid range \"" + range + "\": " + e.getMessage(), e);
        }
    }

    public static VersionRange parse(String range) {
        Assertions.blankCheck(range, "range");
        int idx = range.indexOf(ENDPOINT_DELIMITER);
        if (idx > 1 && idx == range.lastIndexOf(ENDPOINT_DELIMITER)) {
            String vlo = range.substring(0, idx).trim();
            String vhi = range.substring(idx + 1).trim();
            boolean isLowInclusive = true;
            boolean isHighInclusive = true;
            if (vlo.charAt(0) == '(') {
                isLowInclusive = false;
            } else if (vlo.charAt(0) != '[') {
                throw new IllegalArgumentException("invalid range \"" + range + "\": invalid format");
            }
            vlo = vlo.substring(1).trim();
            if (vhi.charAt(vhi.length() - 1) == ')') {
                isHighInclusive = false;
            } else if (vhi.charAt(vhi.length() - 1) != ']') {
                throw new IllegalArgumentException("invalid range \"" + range + "\": invalid format");
            }
            vhi = vhi.substring(0, vhi.length() - 1).trim();
            return new VersionRange(VersionRange.parseVersion(vlo, range), isLowInclusive, VersionRange.parseVersion(vhi, range), isHighInclusive);
        }
        if (idx == -1) {
            return new VersionRange(VersionRange.parseVersion(range.trim(), range), true, null, false);
        }
        throw new IllegalArgumentException("invalid range \"" + range + "\": invalid format");
    }

    public VersionRange(Version low, boolean isLowInclusive, Version high, boolean isHighInclusive) {
        Assertions.nullCheck(low, "floorVersion");
        this.floorVersion = low;
        this.isFloorInclusive = isLowInclusive;
        this.ceilingVersion = high;
        this.isCeilingInclusive = isHighInclusive;
        this.empty = this.isEmpty0();
    }

    public Version getFloor() {
        return this.floorVersion;
    }

    public boolean isFloorInclusive() {
        return this.isFloorInclusive;
    }

    public Version getCeiling() {
        return this.ceilingVersion;
    }

    public boolean isCeilingInclusive() {
        return this.isCeilingInclusive;
    }

    public boolean isInRange(Version version) {
        if (this.empty) {
            return false;
        }
        if (this.floorVersion.compareTo(version) >= (this.isFloorInclusive ? 1 : 0)) {
            return false;
        }
        if (this.ceilingVersion == null) {
            return true;
        }
        return this.ceilingVersion.compareTo(version) >= (this.isCeilingInclusive ? 0 : 1);
    }

    public boolean isExact() {
        if (this.empty) {
            return false;
        }
        if (this.ceilingVersion == null) {
            return true;
        }
        if (this.isFloorInclusive) {
            if (this.isCeilingInclusive) {
                return this.floorVersion.equals(this.ceilingVersion);
            }
            Version adjacent1 = new Version(this.floorVersion.getMajor(), this.floorVersion.getMinor(), this.floorVersion.getMicro(), this.floorVersion.getRevision() + 1);
            return adjacent1.compareTo(this.ceilingVersion) >= 0;
        }
        if (this.isCeilingInclusive) {
            Version adjacent1 = new Version(this.floorVersion.getMajor(), this.floorVersion.getMinor(), this.floorVersion.getMicro(), this.floorVersion.getRevision() + 1);
            return adjacent1.equals(this.ceilingVersion);
        }
        Version adjacent2 = new Version(this.floorVersion.getMajor(), this.floorVersion.getMinor(), this.floorVersion.getMicro(), this.floorVersion.getRevision() + 2);
        return adjacent2.compareTo(this.ceilingVersion) >= 0;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private boolean isEmpty0() {
        if (this.ceilingVersion == null) {
            return false;
        }
        int comparison = this.floorVersion.compareTo(this.ceilingVersion);
        if (comparison == 0) {
            return !this.isFloorInclusive || !this.isCeilingInclusive;
        }
        return comparison > 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionRange other = (VersionRange)obj;
        if (!(this.floorVersion == other.floorVersion || this.floorVersion != null && this.floorVersion.equals(other.floorVersion))) {
            return false;
        }
        if (this.isFloorInclusive != other.isFloorInclusive) {
            return false;
        }
        if (!(this.ceilingVersion == other.ceilingVersion || this.ceilingVersion != null && this.ceilingVersion.equals(other.ceilingVersion))) {
            return false;
        }
        return this.isCeilingInclusive == other.isCeilingInclusive;
    }

    public int hashCode() {
        int result = this.floorVersion.hashCode();
        result = 31 * result + (this.isFloorInclusive ? 1 : 0);
        result = 31 * result + (this.ceilingVersion != null ? this.ceilingVersion.hashCode() : 0);
        result = 31 * result + (this.isCeilingInclusive ? 1 : 0);
        return result;
    }

    public String toString() {
        if (this.ceilingVersion != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.isFloorInclusive ? (char)'[' : '(');
            sb.append(this.floorVersion.getVersion()).append(ENDPOINT_DELIMITER).append(this.ceilingVersion.getVersion());
            sb.append(this.isCeilingInclusive ? (char)']' : ')');
            return sb.toString();
        }
        return this.floorVersion.getVersion();
    }
}

