/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.CasConfigurationPropertiesEnvironmentManager;
import org.apereo.cas.configuration.CommaSeparatedStringToThrowablesConverter;
import org.apereo.cas.configuration.StandaloneConfigurationFilePropertiesSourceLocator;
import org.apereo.cas.configuration.api.CasConfigurationPropertiesSourceLocator;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.support.CasConfigurationJasyptCipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;

@Configuration(value="CasCoreBaseEnvironmentConfiguration", proxyBeanMethods=false)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.CasConfiguration})
class CasCoreBaseEnvironmentConfiguration {
    CasCoreBaseEnvironmentConfiguration() {
    }

    @Configuration(value="CasCoreEnvironmentLocatorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @Lazy(value=false)
    static class CasCoreEnvironmentLocatorConfiguration {
        CasCoreEnvironmentLocatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"standaloneConfigurationFilePropertiesSourceLocator"})
        public static CasConfigurationPropertiesSourceLocator standaloneConfigurationFilePropertiesSourceLocator(@Qualifier(value="casConfigurationCipherExecutor") CipherExecutor<String, String> casConfigurationCipherExecutor) {
            return new StandaloneConfigurationFilePropertiesSourceLocator(casConfigurationCipherExecutor);
        }
    }

    @Configuration(value="CasCoreEnvironmentFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @Lazy(value=false)
    static class CasCoreEnvironmentFactoryConfiguration {
        CasCoreEnvironmentFactoryConfiguration() {
        }

        @ConfigurationPropertiesBinding
        @Bean
        public Converter<String, List<Class<? extends Throwable>>> commaSeparatedStringToThrowablesCollection() {
            return new CommaSeparatedStringToThrowablesConverter();
        }

        @ConditionalOnMissingBean(name={"casConfigurationCipherExecutor"})
        @Bean
        public static CipherExecutor<String, String> casConfigurationCipherExecutor(Environment environment) {
            return new CasConfigurationJasyptCipherExecutor(environment);
        }
    }

    @Configuration(value="CasCoreEnvironmentManagerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @Lazy(value=false)
    static class CasCoreEnvironmentManagerConfiguration {
        CasCoreEnvironmentManagerConfiguration() {
        }

        @ConditionalOnMissingBean(name={"configurationPropertiesEnvironmentManager"})
        @Bean
        public static CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager(ConfigurationPropertiesBindingPostProcessor binder) {
            return new CasConfigurationPropertiesEnvironmentManager(binder);
        }
    }
}

