/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.response;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20DefaultIntrospectionResponseGenerator;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionAccessTokenResponse;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.ServiceAwareTicket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.springframework.beans.factory.ObjectProvider;

public class OidcIntrospectionResponseGenerator
extends OAuth20DefaultIntrospectionResponseGenerator {
    protected final ObjectProvider<OidcConfigurationContext> oidcConfigurationContext;

    protected OAuth20IntrospectionAccessTokenResponse collectIntrospectionDetails(OAuth20IntrospectionAccessTokenResponse response, OAuth20Token accessToken) {
        super.collectIntrospectionDetails(response, accessToken);
        if (accessToken instanceof ServiceAwareTicket) {
            ServiceAwareTicket sat = (ServiceAwareTicket)accessToken;
            Service service = sat.getService();
            OidcRegisteredService registeredService = (OidcRegisteredService)((OidcConfigurationContext)((Object)this.oidcConfigurationContext.getObject())).getServicesManager().findServiceBy(service, OidcRegisteredService.class);
            response.setIss(((OidcConfigurationContext)((Object)this.oidcConfigurationContext.getObject())).getIssuerService().determineIssuer(Optional.ofNullable(registeredService)));
        }
        FunctionUtils.doIf((boolean)response.isActive(), __ -> response.setScope(String.join((CharSequence)" ", accessToken.getScopes()))).accept(response);
        CollectionUtils.firstElement(accessToken.getAuthentication().getAttributes().get("DPoPConfirmation")).ifPresent(dpop -> response.getConfirmation().setJkt(dpop.toString()));
        return response;
    }

    public boolean supports(OAuth20Token accessToken) {
        return super.supports(accessToken) && accessToken != null && accessToken.getScopes().contains(OidcConstants.StandardScopes.OPENID.getScope());
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Generated
    public OidcIntrospectionResponseGenerator(ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
        this.oidcConfigurationContext = oidcConfigurationContext;
    }

    @Generated
    public ObjectProvider<OidcConfigurationContext> getOidcConfigurationContext() {
        return this.oidcConfigurationContext;
    }
}

