/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.impl;

import java.io.Serializable;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRestorationFailureException;
import org.springframework.webflow.execution.repository.impl.FlowExecutionSnapshotGroup;
import org.springframework.webflow.execution.repository.impl.SimpleFlowExecutionSnapshotGroup;
import org.springframework.webflow.execution.repository.snapshot.AbstractSnapshottingFlowExecutionRepository;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshot;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.snapshot.SnapshotNotFoundException;

public class DefaultFlowExecutionRepository
extends AbstractSnapshottingFlowExecutionRepository {
    private static final String SNAPSHOT_GROUP_ATTRIBUTE = "flowExecutionSnapshotGroup";
    private int maxSnapshots = 30;

    public DefaultFlowExecutionRepository(ConversationManager conversationManager, FlowExecutionSnapshotFactory snapshotFactory) {
        super(conversationManager, snapshotFactory);
    }

    public int getMaxSnapshots() {
        return this.maxSnapshots;
    }

    public void setMaxSnapshots(int maxSnapshots) {
        this.maxSnapshots = maxSnapshots;
    }

    @Override
    protected Serializable nextSnapshotId(Serializable executionId) {
        return this.getSnapshotGroup(this.getConversation(executionId)).nextSnapshotId();
    }

    @Override
    public FlowExecution getFlowExecution(FlowExecutionKey key) {
        FlowExecutionSnapshot snapshot;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Getting flow execution with key '" + key + "'"));
        }
        Conversation conversation = this.getConversation(key);
        try {
            snapshot = this.getSnapshotGroup(conversation).getSnapshot(this.getSnapshotId(key));
        }
        catch (SnapshotNotFoundException e) {
            throw new FlowExecutionRestorationFailureException(key, e);
        }
        return this.restoreFlowExecution(snapshot, key, conversation);
    }

    @Override
    public void putFlowExecution(FlowExecution flowExecution) {
        this.assertKeySet(flowExecution);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Putting flow execution '" + flowExecution + "' into repository"));
        }
        FlowExecutionKey key = flowExecution.getKey();
        Conversation conversation = this.getConversation(key);
        FlowExecutionSnapshotGroup snapshotGroup = this.getSnapshotGroup(conversation);
        FlowExecutionSnapshot snapshot = this.snapshot(flowExecution);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding snapshot to group with id " + this.getSnapshotId(key)));
        }
        snapshotGroup.addSnapshot(this.getSnapshotId(key), snapshot);
        this.putConversationScope(flowExecution, conversation);
    }

    @Override
    public void updateFlowExecutionSnapshot(FlowExecution execution) {
        FlowExecutionKey key = execution.getKey();
        if (key == null) {
            return;
        }
        Conversation conversation = this.getConversation(key);
        this.getSnapshotGroup(conversation).updateSnapshot(this.getSnapshotId(key), this.snapshot(execution));
    }

    @Override
    public void removeFlowExecutionSnapshot(FlowExecution execution) {
        FlowExecutionKey key = execution.getKey();
        if (key == null) {
            return;
        }
        Conversation conversation = this.getConversation(key);
        this.getSnapshotGroup(conversation).removeSnapshot(this.getSnapshotId(key));
    }

    @Override
    public void removeAllFlowExecutionSnapshots(FlowExecution execution) {
        FlowExecutionKey key = execution.getKey();
        if (key == null) {
            return;
        }
        Conversation conversation = this.getConversation(execution.getKey());
        this.getSnapshotGroup(conversation).removeAllSnapshots();
    }

    protected FlowExecutionSnapshotGroup createFlowExecutionSnapshotGroup() {
        SimpleFlowExecutionSnapshotGroup group = new SimpleFlowExecutionSnapshotGroup();
        group.setMaxSnapshots(this.maxSnapshots);
        return group;
    }

    protected FlowExecutionSnapshotGroup getSnapshotGroup(Conversation conversation) {
        FlowExecutionSnapshotGroup group = (FlowExecutionSnapshotGroup)conversation.getAttribute(SNAPSHOT_GROUP_ATTRIBUTE);
        if (group == null) {
            group = this.createFlowExecutionSnapshotGroup();
            conversation.putAttribute(SNAPSHOT_GROUP_ATTRIBUTE, group);
        }
        return group;
    }
}

