/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.provisioning.api.data.SchemaDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaDataBinderImpl
implements SchemaDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(SchemaDataBinder.class);
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final DerSchemaDAO derSchemaDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final AnyTypeDAO anyTypeDAO;
    protected final ImplementationDAO implementationDAO;
    protected final EntityFactory entityFactory;
    protected final AnyUtilsFactory anyUtilsFactory;

    public SchemaDataBinderImpl(AnyTypeClassDAO anyTypeClassDAO, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, ExternalResourceDAO resourceDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory) {
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.derSchemaDAO = derSchemaDAO;
        this.resourceDAO = resourceDAO;
        this.anyTypeDAO = anyTypeDAO;
        this.implementationDAO = implementationDAO;
        this.entityFactory = entityFactory;
        this.anyUtilsFactory = anyUtilsFactory;
    }

    protected PlainSchema fill(PlainSchema schema, PlainSchemaTO schemaTO) {
        if (!JexlUtils.isExpressionValid((String)schemaTO.getMandatoryCondition())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
            sce.getElements().add(schemaTO.getMandatoryCondition());
            throw sce;
        }
        schema.setKey(schemaTO.getKey());
        schema.setType(schemaTO.getType());
        schema.setCipherAlgorithm(schemaTO.getCipherAlgorithm());
        schema.setConversionPattern(schemaTO.getConversionPattern());
        schema.getEnumValues().clear();
        schema.getEnumValues().putAll(schemaTO.getEnumValues());
        if (schemaTO.getDropdownValueProvider() == null) {
            schema.setDropdownValueProvider(null);
        } else {
            this.implementationDAO.findById(schemaTO.getDropdownValueProvider()).ifPresentOrElse(arg_0 -> ((PlainSchema)schema).setDropdownValueProvider(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), (Object)schemaTO.getDropdownValueProvider()));
        }
        schema.setMandatoryCondition(schemaTO.getMandatoryCondition());
        schema.setMimeType(schemaTO.getMimeType());
        schema.setMultivalue(schemaTO.isMultivalue());
        schema.setReadonly(schemaTO.isReadonly());
        schema.setSecretKey(schemaTO.getSecretKey());
        schema.setUniqueConstraint(schemaTO.isUniqueConstraint());
        schema.getLabels().clear();
        schema.getLabels().putAll(schemaTO.getLabels());
        if (schemaTO.getValidator() == null) {
            schema.setValidator(null);
        } else {
            this.implementationDAO.findById(schemaTO.getValidator()).ifPresentOrElse(arg_0 -> ((PlainSchema)schema).setValidator(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), (Object)schemaTO.getValidator()));
        }
        PlainSchema saved = (PlainSchema)this.plainSchemaDAO.save((Entity)schema);
        MutableObject atc = new MutableObject();
        if (!(schemaTO.getAnyTypeClass() == null || saved.getAnyTypeClass() != null && schemaTO.getAnyTypeClass().equals(saved.getAnyTypeClass().getKey()))) {
            this.anyTypeClassDAO.findById(schemaTO.getAnyTypeClass()).ifPresentOrElse(arg_0 -> SchemaDataBinderImpl.lambda$fill$2(saved, (Mutable)atc, arg_0), () -> LOG.debug("Invalid {}{}, ignoring...", (Object)AnyTypeClass.class.getSimpleName(), (Object)schemaTO.getAnyTypeClass()));
        } else if (schemaTO.getAnyTypeClass() == null && saved.getAnyTypeClass() != null) {
            saved.getAnyTypeClass().getPlainSchemas().remove(saved);
            saved.setAnyTypeClass(null);
            atc.setValue((Object)saved.getAnyTypeClass());
        }
        PlainSchema filled = (PlainSchema)this.plainSchemaDAO.save((Entity)saved);
        Optional.ofNullable((AnyTypeClass)atc.get()).ifPresent(arg_0 -> ((AnyTypeClassDAO)this.anyTypeClassDAO).save(arg_0));
        return filled;
    }

    public PlainSchema create(PlainSchemaTO schemaTO) {
        return this.fill((PlainSchema)this.entityFactory.newEntity(PlainSchema.class), schemaTO);
    }

    public PlainSchema update(PlainSchemaTO schemaTO, PlainSchema schema) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        if (this.plainSchemaDAO.hasAttrs(schema)) {
            SyncopeClientException e;
            if (schema.getType() != schemaTO.getType()) {
                e = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPlainSchema);
                e.getElements().add("Cannot change type since " + schema.getKey() + " has attributes");
                scce.addException(e);
            }
            if (schema.isUniqueConstraint() != schemaTO.isUniqueConstraint()) {
                e = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPlainSchema);
                e.getElements().add("Cannot alter unique contraint since " + schema.getKey() + " has attributes");
                scce.addException(e);
            }
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        return this.fill(schema, schemaTO);
    }

    public PlainSchemaTO getPlainSchemaTO(String key) {
        PlainSchema schema = (PlainSchema)this.plainSchemaDAO.findById(key).orElseThrow(() -> new NotFoundException("PlainSchema " + key));
        PlainSchemaTO schemaTO = new PlainSchemaTO();
        schemaTO.setKey(schema.getKey());
        schemaTO.setType(schema.getType());
        schemaTO.setCipherAlgorithm(schema.getCipherAlgorithm());
        schemaTO.setConversionPattern(schema.getConversionPattern());
        schemaTO.getEnumValues().putAll(schema.getEnumValues());
        Optional.ofNullable(schema.getDropdownValueProvider()).ifPresent(v -> schemaTO.setDropdownValueProvider(v.getKey()));
        schemaTO.setMandatoryCondition(schema.getMandatoryCondition());
        schemaTO.setMimeType(schema.getMimeType());
        schemaTO.setMultivalue(schema.isMultivalue());
        schemaTO.setReadonly(schema.isReadonly());
        schemaTO.setSecretKey(schema.getSecretKey());
        schemaTO.setUniqueConstraint(schema.isUniqueConstraint());
        schemaTO.getLabels().putAll(schema.getLabels());
        Optional.ofNullable(schema.getAnyTypeClass()).ifPresent(v -> schemaTO.setAnyTypeClass(v.getKey()));
        Optional.ofNullable(schema.getValidator()).ifPresent(v -> schemaTO.setValidator(v.getKey()));
        return schemaTO;
    }

    protected DerSchema fill(DerSchema schema, DerSchemaTO schemaTO) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        if (StringUtils.isBlank((CharSequence)schemaTO.getExpression())) {
            SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            requiredValuesMissing.getElements().add("expression");
            scce.addException(requiredValuesMissing);
        } else if (!JexlUtils.isExpressionValid((String)schemaTO.getExpression())) {
            SyncopeClientException e = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
            e.getElements().add(schemaTO.getExpression());
            scce.addException(e);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        schema.setKey(schemaTO.getKey());
        schema.setExpression(schemaTO.getExpression());
        schema.getLabels().clear();
        schema.getLabels().putAll(schemaTO.getLabels());
        DerSchema saved = (DerSchema)this.derSchemaDAO.save((Entity)schema);
        MutableObject atc = new MutableObject();
        if (!(schemaTO.getAnyTypeClass() == null || saved.getAnyTypeClass() != null && schemaTO.getAnyTypeClass().equals(saved.getAnyTypeClass().getKey()))) {
            this.anyTypeClassDAO.findById(schemaTO.getAnyTypeClass()).ifPresentOrElse(arg_0 -> SchemaDataBinderImpl.lambda$fill$8(saved, (Mutable)atc, arg_0), () -> LOG.debug("Invalid {}{}, ignoring...", (Object)AnyTypeClass.class.getSimpleName(), (Object)schemaTO.getAnyTypeClass()));
        } else if (schemaTO.getAnyTypeClass() == null && saved.getAnyTypeClass() != null) {
            saved.getAnyTypeClass().getDerSchemas().remove(saved);
            saved.setAnyTypeClass(null);
            atc.setValue((Object)saved.getAnyTypeClass());
        }
        DerSchema filled = (DerSchema)this.derSchemaDAO.save((Entity)saved);
        Optional.ofNullable((AnyTypeClass)atc.get()).ifPresent(arg_0 -> ((AnyTypeClassDAO)this.anyTypeClassDAO).save(arg_0));
        return filled;
    }

    public DerSchema create(DerSchemaTO schemaTO) {
        return this.fill((DerSchema)this.entityFactory.newEntity(DerSchema.class), schemaTO);
    }

    public DerSchema update(DerSchemaTO schemaTO, DerSchema schema) {
        return this.fill(schema, schemaTO);
    }

    public DerSchemaTO getDerSchemaTO(String key) {
        DerSchema schema = (DerSchema)this.derSchemaDAO.findById(key).orElseThrow(() -> new NotFoundException("DerSchema " + key));
        DerSchemaTO schemaTO = new DerSchemaTO();
        schemaTO.setKey(schema.getKey());
        schemaTO.setExpression(schema.getExpression());
        schemaTO.getLabels().putAll(schema.getLabels());
        schemaTO.setAnyTypeClass(schema.getAnyTypeClass() == null ? null : schema.getAnyTypeClass().getKey());
        return schemaTO;
    }

    private static /* synthetic */ void lambda$fill$8(DerSchema saved, Mutable atc, AnyTypeClass anyTypeClass) {
        anyTypeClass.add(saved);
        saved.setAnyTypeClass(anyTypeClass);
        atc.setValue((Object)anyTypeClass);
    }

    private static /* synthetic */ void lambda$fill$2(PlainSchema saved, Mutable atc, AnyTypeClass anyTypeClass) {
        anyTypeClass.add(saved);
        saved.setAnyTypeClass(anyTypeClass);
        atc.setValue((Object)anyTypeClass);
    }
}

