/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.BaseSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedAuthenticationSingleSignOnParticipationStrategy
extends BaseSingleSignOnParticipationStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationSingleSignOnParticipationStrategy.class);

    public DelegatedAuthenticationSingleSignOnParticipationStrategy(ServicesManager servicesManager, AuthenticationServiceSelectionPlan serviceSelectionStrategy, TicketRegistrySupport ticketRegistrySupport) {
        super(servicesManager, ticketRegistrySupport, serviceSelectionStrategy);
    }

    public boolean isParticipating(SingleSignOnParticipationRequest ssoRequest) {
        RegisteredService registeredService = this.getRegisteredService(ssoRequest);
        if (registeredService == null) {
            return true;
        }
        RegisteredServiceAccessStrategy accessStrategy = registeredService.getAccessStrategy();
        if (accessStrategy == null || accessStrategy.getDelegatedAuthenticationPolicy() == null) {
            return true;
        }
        Optional ticketGrantingTicketId = DelegatedAuthenticationSingleSignOnParticipationStrategy.getTicketGrantingTicketId((SingleSignOnParticipationRequest)ssoRequest);
        if (ticketGrantingTicketId.isEmpty()) {
            return true;
        }
        Authentication authentication = this.getTicketState(ssoRequest).map(AuthenticationAwareTicket.class::cast).map(AuthenticationAwareTicket::getAuthentication).orElseThrow(() -> new InvalidTicketException((String)ticketGrantingTicketId.get()));
        RegisteredServiceDelegatedAuthenticationPolicy policy = accessStrategy.getDelegatedAuthenticationPolicy();
        Map attributes = authentication.getAttributes();
        if (attributes.containsKey("clientName")) {
            List clientNameAttr = (List)attributes.get("clientName");
            Optional value = CollectionUtils.firstElement((Object)clientNameAttr);
            if (value.isPresent()) {
                String client = value.get().toString();
                LOGGER.debug("Evaluating delegated access strategy for client [{}] and service [{}]", (Object)client, (Object)registeredService);
                return policy.isProviderAllowed(client, registeredService);
            }
            return false;
        }
        return !policy.isProviderRequired();
    }

    public boolean supports(SingleSignOnParticipationRequest ssoRequest) {
        RegisteredService registeredService = this.getRegisteredService(ssoRequest);
        if (registeredService == null) {
            return false;
        }
        RegisteredServiceAccessStrategy accessStrategy = registeredService.getAccessStrategy();
        return accessStrategy != null && accessStrategy.getDelegatedAuthenticationPolicy() != null;
    }

    public int getOrder() {
        return 0;
    }
}

