/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.time.Duration;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.pages.BrowserInfoForm;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Args;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;

public class AjaxClientInfoBehavior
extends AbstractAjaxTimerBehavior {
    private static final long serialVersionUID = 1L;

    public AjaxClientInfoBehavior() {
        this(Duration.ofMillis(50L));
    }

    public AjaxClientInfoBehavior(Duration duration) {
        super(duration);
    }

    @Override
    protected final void onTimer(AjaxRequestTarget target) {
        this.stop(target);
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters requestParameters = requestCycle.getRequest().getRequestParameters();
        WebClientInfo clientInfo = this.newWebClientInfo(requestCycle);
        clientInfo.getProperties().read(requestParameters);
        Session.get().setClientInfo(clientInfo);
        this.onClientInfo(target, clientInfo);
    }

    protected WebClientInfo newWebClientInfo(RequestCycle requestCycle) {
        return new WebClientInfo(requestCycle);
    }

    protected void onClientInfo(AjaxRequestTarget target, WebClientInfo clientInfo) {
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.getDynamicExtraParameters().add("return Wicket.BrowserInfo.collect()");
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render(JavaScriptHeaderItem.forReference(BrowserInfoForm.JS));
    }

    public static AjaxClientInfoBehavior onClientInfo(final SerializableBiConsumer<AjaxRequestTarget, WebClientInfo> onClientInfo) {
        Args.notNull(onClientInfo, (String)"onClientInfo");
        return new AjaxClientInfoBehavior(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClientInfo(AjaxRequestTarget target, WebClientInfo clientInfo) {
                onClientInfo.accept((Object)target, (Object)clientInfo);
            }
        };
    }
}

