/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.template;

import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.css.ICssCompressor;
import org.apache.wicket.util.template.TextTemplate;
import org.apache.wicket.util.template.TextTemplateDecorator;

public final class CssTemplate
extends TextTemplateDecorator {
    private static final long serialVersionUID = 1L;

    public CssTemplate(TextTemplate textTemplate) {
        super(textTemplate);
    }

    @Override
    public String getBeforeTemplateContents() {
        return "<style type=\"text/css\">\n";
    }

    @Override
    public String getAfterTemplateContents() {
        return "</style>\n";
    }

    @Override
    public TextTemplate interpolate(Map<String, ?> variables) {
        return this;
    }

    @Override
    public String getString() {
        String nonCompressed = super.getString();
        ICssCompressor compressor = null;
        if (Application.exists()) {
            compressor = Application.get().getResourceSettings().getCssCompressor();
        }
        if (compressor != null) {
            return compressor.compress(nonCompressed);
        }
        return nonCompressed;
    }
}

