/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.tester;

import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.registry.IKey;

abstract class TestWebSocketConnection
implements IWebSocketConnection {
    private final WebApplication application;
    private final String sessionId;
    private final IKey registryKey;
    private boolean isOpen = true;

    public TestWebSocketConnection(WebApplication application, String sessionId, IKey registryKey) {
        this.application = application;
        this.sessionId = sessionId;
        this.registryKey = registryKey;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close(int code, String reason) {
        this.isOpen = false;
    }

    public IWebSocketConnection sendMessage(String message) throws IOException {
        this.checkOpenness();
        this.onOutMessage(message);
        return this;
    }

    public Future<Void> sendMessageAsync(String message) {
        return this.sendMessageAsync(message, -1L);
    }

    public Future<Void> sendMessageAsync(String message, long timeOut) {
        this.checkOpenness();
        this.onOutMessage(message);
        return null;
    }

    public IWebSocketConnection sendMessage(byte[] message, int offset, int length) throws IOException {
        this.checkOpenness();
        this.onOutMessage(message, offset, length);
        return this;
    }

    public Future<Void> sendMessageAsync(byte[] message, int offset, int length) {
        return this.sendMessageAsync(message, offset, length, -1L);
    }

    public Future<Void> sendMessageAsync(byte[] message, int offset, int length, long timeout) {
        this.checkOpenness();
        this.onOutMessage(message, offset, length);
        return null;
    }

    protected abstract void onOutMessage(String var1);

    protected abstract void onOutMessage(byte[] var1, int var2, int var3);

    private void checkOpenness() {
        if (!this.isOpen()) {
            throw new IllegalStateException("The connection is closed!");
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public IKey getKey() {
        return this.registryKey;
    }
}

