// LinkDialog.cpp : implementation file
//

#include "stdafx.h"
#include "DFE32.h"
#include "LinkDialog.h"
#include "extern.h"
#include "messageview.h"
#include "postmessage.h"
#include "fork.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLinkDialog dialog


CLinkDialog::CLinkDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CLinkDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLinkDialog)
	m_Output = _T("");
	//}}AFX_DATA_INIT
}


void CLinkDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLinkDialog)
	DDX_Text(pDX, IDC_OUTPUT_EDIT, m_Output);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLinkDialog, CDialog)
	//{{AFX_MSG_MAP(CLinkDialog)
	ON_BN_CLICKED(IDC_ADD_BUTTON, OnAddButton)
	ON_BN_CLICKED(IDC_REMOVE_BUTTON, OnRemoveButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLinkDialog message handlers

void CLinkDialog::OnAddButton() 
{
	// TODO: Add your control notification handler code here
	CString ext;
	CString str;
	CFileDialog filedialog(TRUE, NULL, NULL, OFN_HIDEREADONLY | 
		OFN_OVERWRITEPROMPT, 
		"Object and Library Files (*.a), (*.so), (*.o)| *.a;*.so;*.o||");
	CListBox *list = (CListBox*)GetDlgItem(IDC_LINK_LIST);
	if (filedialog.DoModal() == IDOK)
	{
		ext = filedialog.GetFileExt();
		str = filedialog.GetFileName();
		if (!ext.CompareNoCase("o"))
			list->AddString(filedialog.GetPathName());
		else if (!ext.CompareNoCase("a"))
		{
			str = str.Left(str.GetLength()-2);
			str = str.Right(str.GetLength()-3);
			list->AddString(str);
		}
		else
		{
			str = str.Left(str.GetLength()-3);
			str = str.Right(str.GetLength()-3);
			list->AddString(str);
		}
	}
}

void CLinkDialog::OnRemoveButton() 
{
	// TODO: Add your control notification handler code here
	CListBox *list = (CListBox*)GetDlgItem(IDC_LINK_LIST);
	if (list->GetCurSel() != LB_ERR)
		list->DeleteString(list->GetCurSel());	
}

void CLinkDialog::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);
	HANDLE in, out, err, thread;
	DWORD number;
	CString output, temp;
	char buffer[5000];
	memset(buffer, '\0', 4500);
	CString str;
	CString liststr;
	CListBox *list = (CListBox *)GetDlgItem(IDC_LINK_LIST);
	int i;
	str = gccpath;
	str += " ";
	str += "-o ";
	str += m_Output;
	str += " ";
	if (list->GetCount() != 0)
	{
		for (i = 0; i < list->GetCount(); i++)
		{
			list->GetText(i, liststr);
			if (liststr.GetLength() > 2)
			{
				if (liststr.GetAt(liststr.GetLength() - 2) == '.')
				{
					list->GetText(i, liststr);
					str += liststr;
					str += " ";
				}
			}
		}
		for (i = 0; i < list->GetCount(); i++)
		{
			list->GetText(i, liststr);
			if (liststr.GetLength() <= 2)
			{
				str += "-l";
				str += liststr;
				str += " ";
			}
			else if (liststr.GetAt(liststr.GetLength() - 2) != '.')
			{
				str += "-l";
				str += liststr;
				str += " ";
			}
		}
	}
	if (clear)
		GlobalMessageView->Reset();
	output = "Linking with command line of:";
	PostOutput(output, FALSE);
	output = str;
	PostOutput(output, TRUE);
	thread = ForkChildProcess(str.GetBuffer(500), &in, &out, &err, TRUE);
	WaitForSingleObject(thread, INFINITE);
	PeekNamedPipe(err,NULL,NULL,NULL,&number,NULL);
	if (number == 0)
	{
		output = "No warnings or errors recieved from gcc";
		PostOutput(output, TRUE);
	}
	else
	{
		output = "Errors:";
		PostOutput(output, TRUE);
		ReadFile(err, buffer, 4000, &number, NULL);
		temp = buffer;
		while (1)
		{
			if (temp.Find('\n') != -1)
			{
				output = temp.Left(temp.Find('\n') - 1);
				temp = temp.Right(temp.GetLength() - (temp.Find('\n') + 1));
				PostOutput(output, FALSE);
				if (temp.Find('\n') == -1)
				{
					PostOutput(temp, FALSE);
					break;
				}
			}
			else
			{
				PostOutput(temp, FALSE);
				break;
			}
		}
	}
	CDialog::OnOK();
}

BOOL CLinkDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CString str('x', (3 - extension.GetLength()));
	if (!filename.IsEmpty())
	{
		m_Output = filename + str;
		m_Output.SetAt(m_Output.GetLength() - 3, 'e');
		m_Output.SetAt(m_Output.GetLength() - 2, 'x');
		m_Output.SetAt(m_Output.GetLength() - 1, 'e');
	}
	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
