/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.actions;

import org.eclipse.jface.action.Action;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IDisposable2;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;

public abstract class PageAction
extends Action
implements IDisposable2 {
    private IGraphicalEditorPage page;

    protected PageAction(IGraphicalEditorPage page) {
        this.page = page;
    }

    protected PageAction(String id, IGraphicalEditorPage page) {
        this(page);
        this.setId(id);
    }

    protected IGraphicalEditorPage getPage() {
        return this.page;
    }

    protected IGraphicalViewer getViewer() {
        return this.page == null ? null : this.page.getViewer();
    }

    protected EditDomain getEditDomain() {
        return this.page == null ? null : this.page.getEditDomain();
    }

    protected ITool getActiveTool() {
        EditDomain domain = this.getEditDomain();
        return domain == null ? null : domain.getActiveTool();
    }

    protected void sendRequest(String request) {
        EditDomain domain = this.getEditDomain();
        if (domain != null) {
            domain.handleRequest(request, (IViewer)this.getViewer());
        }
    }

    protected void sendRequest(Request request) {
        request.setViewer((IViewer)this.getViewer());
        EditDomain domain = this.getEditDomain();
        if (domain != null) {
            domain.handleRequest(request);
        }
    }

    protected IGraphicalEditor getEditor() {
        return this.page == null ? null : this.page.getParentEditor();
    }

    protected ICommandStack getCommandStack() {
        IGraphicalEditor editor = this.getEditor();
        return editor == null ? null : editor.getCommandStack();
    }

    protected void saveAndRun(Command command) {
        ICommandStack cs = this.getCommandStack();
        if (cs != null) {
            cs.execute(command);
        }
    }

    public void dispose() {
        this.page = null;
    }

    public boolean isDisposed() {
        return this.page == null || this.page.isDisposed();
    }
}

