/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.graphics;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextLayout;
import org.xmind.gef.draw2d.graphics.GradientPattern;

public abstract class ColorMaskGraphics
extends Graphics {
    private Graphics delegate;
    private Stack<Color> fgColors;
    private Stack<Color> bgColors;
    private Color localForeground;
    private Color localBackground;
    private int localAlpha;
    private Map<RGB, Color> workingColors;
    private Stack<Pattern> fgPatterns;
    private Stack<Pattern> bgPatterns;
    private Pattern currentFgPattern;
    private Pattern currentBgPattern;

    public ColorMaskGraphics(Graphics delegate, Object ... args) {
        this.delegate = delegate;
        this.init(args);
        delegate.pushState();
        this.localForeground = delegate.getForegroundColor();
        this.localBackground = delegate.getBackgroundColor();
        this.pushColors();
        this.localAlpha = delegate.getAlpha();
        delegate.setForegroundColor(this.getWorkingColor(this.localForeground));
        delegate.setBackgroundColor(this.getWorkingColor(this.localBackground));
        delegate.setAlpha(255);
    }

    protected void init(Object ... args) {
    }

    protected abstract RGB getMaskColor(RGB var1);

    private void pushColors() {
        if (this.fgColors == null) {
            this.fgColors = new Stack();
        }
        this.fgColors.push(this.localForeground);
        if (this.bgColors == null) {
            this.bgColors = new Stack();
        }
        this.bgColors.push(this.localBackground);
    }

    private void restoreColors() {
        if (this.fgColors != null && !this.fgColors.isEmpty()) {
            this.localForeground = this.fgColors.peek();
        }
        if (this.bgColors != null && !this.bgColors.isEmpty()) {
            this.localBackground = this.bgColors.peek();
        }
    }

    private void popupColors() {
        if (this.fgColors != null && !this.fgColors.isEmpty()) {
            this.localForeground = this.fgColors.pop();
        }
        if (this.bgColors != null && !this.bgColors.isEmpty()) {
            this.localBackground = this.bgColors.pop();
        }
    }

    protected Graphics getDelegate() {
        return this.delegate;
    }

    protected Color getWorkingColor(Color c) {
        Color grayed;
        if (c == null) {
            return null;
        }
        RGB rgb = c.getRGB();
        if (this.workingColors == null) {
            this.workingColors = new HashMap<RGB, Color>();
        }
        if ((grayed = this.workingColors.get(rgb)) == null) {
            grayed = this.createWorkingColor(c.getDevice(), rgb);
            this.workingColors.put(rgb, grayed);
        }
        return grayed;
    }

    private Color createWorkingColor(Device device, RGB rgb) {
        return new Color(device, this.getMaskColor(rgb));
    }

    public void setForegroundColor(Color rgb) {
        if (rgb.isDisposed()) {
            System.out.println("!!!Color Disposed: " + rgb);
        }
        this.localForeground = rgb;
        this.delegate.setForegroundColor(this.getWorkingColor(rgb));
    }

    public void setBackgroundColor(Color rgb) {
        this.localBackground = rgb;
        this.delegate.setBackgroundColor(this.getWorkingColor(rgb));
    }

    public Color getForegroundColor() {
        return this.localForeground;
    }

    public Color getBackgroundColor() {
        return this.localBackground;
    }

    public void setAlpha(int alpha) {
        this.localAlpha = alpha;
        if (alpha == 0) {
            this.delegate.setAlpha(alpha);
        } else {
            this.delegate.setAlpha(255);
        }
    }

    public int getAlpha() {
        return this.localAlpha;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.currentFgPattern != null) {
            this.currentFgPattern.dispose();
            this.currentFgPattern = null;
        }
        if (pattern instanceof GradientPattern) {
            GradientPattern gp = (GradientPattern)pattern;
            this.currentFgPattern = pattern = this.createGrayedPattern(gp);
        }
        this.delegate.setForegroundPattern(pattern);
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.currentBgPattern != null) {
            this.currentBgPattern.dispose();
            this.currentBgPattern = null;
        }
        if (pattern instanceof GradientPattern) {
            GradientPattern gp = (GradientPattern)pattern;
            this.currentBgPattern = pattern = this.createGrayedPattern(gp);
        }
        this.delegate.setBackgroundPattern(pattern);
    }

    private Pattern createGrayedPattern(GradientPattern p) {
        return new GradientPattern(p.getDevice(), p.x1, p.y1, p.x2, p.y2, this.getWorkingColor(p.color1), 255, this.getWorkingColor(p.color2), 255);
    }

    public void dispose() {
        this.popupColors();
        this.delegate.popState();
        if (this.workingColors != null) {
            for (Color c : this.workingColors.values()) {
                c.dispose();
            }
            this.workingColors = null;
        }
        if (this.currentFgPattern != null) {
            this.currentFgPattern.dispose();
            this.currentFgPattern = null;
        }
        if (this.currentBgPattern != null) {
            this.currentBgPattern.dispose();
            this.currentBgPattern = null;
        }
        if (this.fgPatterns != null) {
            for (Pattern p : this.fgPatterns) {
                if (p == null) continue;
                p.dispose();
            }
            this.fgPatterns = null;
        }
        if (this.bgPatterns != null) {
            for (Pattern p : this.bgPatterns) {
                if (p == null) continue;
                p.dispose();
            }
            this.bgPatterns = null;
        }
    }

    public void pushState() {
        this.delegate.pushState();
        this.pushColors();
        if (this.fgPatterns == null) {
            this.fgPatterns = new Stack();
        }
        this.fgPatterns.push(this.currentFgPattern);
        this.currentFgPattern = null;
        if (this.bgPatterns == null) {
            this.bgPatterns = new Stack();
        }
        this.bgPatterns.push(this.currentBgPattern);
        this.currentBgPattern = null;
    }

    public void popState() {
        this.delegate.popState();
        this.popupColors();
        if (this.currentFgPattern != null) {
            this.currentFgPattern.dispose();
            this.currentFgPattern = null;
        }
        if (this.fgPatterns != null) {
            this.currentFgPattern = this.fgPatterns.pop();
        }
        if (this.currentBgPattern != null) {
            this.currentBgPattern.dispose();
            this.currentBgPattern = null;
        }
        if (this.bgPatterns != null) {
            this.currentBgPattern = this.bgPatterns.pop();
        }
    }

    public void restoreState() {
        this.delegate.restoreState();
        this.restoreColors();
    }

    public void clipRect(Rectangle r) {
        this.delegate.clipRect(r);
    }

    public void clipPath(Path path) {
        this.delegate.clipPath(path);
    }

    public void drawArc(int x, int y, int w, int h, int offset, int length) {
        this.delegate.drawArc(x, y, w, h, offset, length);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.delegate.drawFocus(x, y, w, h);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        this.delegate.drawImage(srcImage, x1, y1, w1, h1, x2, y2, w2, h2);
    }

    public void drawImage(Image srcImage, int x, int y) {
        this.delegate.drawImage(srcImage, x, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.delegate.drawLine(x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int w, int h) {
        this.delegate.drawOval(x, y, w, h);
    }

    public void drawPath(Path path) {
        this.delegate.drawPath(path);
    }

    public void drawPoint(int x, int y) {
        this.delegate.drawPoint(x, y);
    }

    public void drawPolygon(int[] points) {
        this.delegate.drawPolygon(points);
    }

    public void drawPolygon(PointList points) {
        this.delegate.drawPolygon(points);
    }

    public void drawPolyline(int[] points) {
        this.delegate.drawPolyline(points);
    }

    public void drawPolyline(PointList points) {
        this.delegate.drawPolyline(points);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.delegate.drawRectangle(x, y, width, height);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.delegate.drawRoundRectangle(r, arcWidth, arcHeight);
    }

    public void drawString(String s, int x, int y) {
        this.delegate.drawString(s, x, y);
    }

    public void drawText(String s, int x, int y, int style) {
        this.delegate.drawText(s, x, y, style);
    }

    public void drawText(String s, int x, int y) {
        this.delegate.drawText(s, x, y);
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.delegate.drawTextLayout(layout, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground);
    }

    public void fillArc(int x, int y, int w, int h, int offset, int length) {
        this.delegate.fillArc(x, y, w, h, offset, length);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.delegate.fillGradient(x, y, w, h, vertical);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.delegate.fillOval(x, y, w, h);
    }

    public void fillPath(Path path) {
        this.delegate.fillPath(path);
    }

    public void fillPolygon(int[] points) {
        this.delegate.fillPolygon(points);
    }

    public void fillPolygon(PointList points) {
        this.delegate.fillPolygon(points);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.delegate.fillRectangle(x, y, width, height);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.delegate.fillRoundRectangle(r, arcWidth, arcHeight);
    }

    public void fillString(String s, int x, int y) {
        this.delegate.fillString(s, x, y);
    }

    public void fillText(String s, int x, int y) {
        this.delegate.fillText(s, x, y);
    }

    public double getAbsoluteScale() {
        return this.delegate.getAbsoluteScale();
    }

    public int getAntialias() {
        return this.delegate.getAntialias();
    }

    public Rectangle getClip(Rectangle rect) {
        return this.delegate.getClip(rect);
    }

    public int getFillRule() {
        return this.delegate.getFillRule();
    }

    public Font getFont() {
        return this.delegate.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.delegate.getFontMetrics();
    }

    public int getInterpolation() {
        return this.delegate.getInterpolation();
    }

    public int getLineCap() {
        return this.delegate.getLineCap();
    }

    public int getLineJoin() {
        return this.delegate.getLineJoin();
    }

    public int getLineStyle() {
        return this.delegate.getLineStyle();
    }

    public int getLineWidth() {
        return this.delegate.getLineWidth();
    }

    public int getTextAntialias() {
        return this.delegate.getTextAntialias();
    }

    public boolean getXORMode() {
        return this.delegate.getXORMode();
    }

    public void rotate(float degrees) {
        this.delegate.rotate(degrees);
    }

    public void scale(double amount) {
        this.delegate.scale(amount);
    }

    public void scale(float horizontal, float vertical) {
        this.delegate.scale(horizontal, vertical);
    }

    public void setAntialias(int value) {
        this.delegate.setAntialias(value);
    }

    public void setClip(Path path) {
        this.delegate.setClip(path);
    }

    public void setClip(Rectangle r) {
        this.delegate.setClip(r);
    }

    public void setFillRule(int rule) {
        this.delegate.setFillRule(rule);
    }

    public void setFont(Font f) {
        this.delegate.setFont(f);
    }

    public void setInterpolation(int interpolation) {
        this.delegate.setInterpolation(interpolation);
    }

    public void setLineCap(int cap) {
        this.delegate.setLineCap(cap);
    }

    public void setLineDash(int[] dash) {
        this.delegate.setLineDash(dash);
    }

    public void setLineJoin(int join) {
        this.delegate.setLineJoin(join);
    }

    public void setLineStyle(int style) {
        this.delegate.setLineStyle(style);
    }

    public void setLineWidth(int width) {
        this.delegate.setLineWidth(width);
    }

    public void setTextAntialias(int value) {
        this.delegate.setTextAntialias(value);
    }

    public void setXORMode(boolean b) {
        this.delegate.setXORMode(b);
    }

    public void shear(float horz, float vert) {
        this.delegate.shear(horz, vert);
    }

    public void translate(float dx, float dy) {
        this.delegate.translate(dx, dy);
    }

    public void translate(int dx, int dy) {
        this.delegate.translate(dx, dy);
    }

    public boolean getAdvanced() {
        return this.delegate.getAdvanced();
    }

    public float getLineMiterLimit() {
        return this.delegate.getLineMiterLimit();
    }

    public LineAttributes getLineAttributes() {
        return this.delegate.getLineAttributes();
    }

    public float getLineWidthFloat() {
        return this.delegate.getLineWidthFloat();
    }

    public void setAdvanced(boolean advanced) {
        this.delegate.setAdvanced(advanced);
    }

    public void setLineMiterLimit(float miterLimit) {
        this.delegate.setLineMiterLimit(miterLimit);
    }

    public void setLineWidthFloat(float width) {
        this.delegate.setLineWidthFloat(width);
    }

    public void setLineAttributes(LineAttributes attributes) {
        this.delegate.setLineAttributes(attributes);
    }

    public void setLineDash(float[] value) {
        this.delegate.setLineDash(value);
    }
}

